% GSPBOX - Demos
%
%  Introduction to the GSPBox
%    gsp_demo                -  Small tutorial on the GSPBox
%    gsp_demo_wavelet        -  Introduction to spectral wavelets
%    gsp_demo_graph_embedding -  Introduction to use embeddings
%
%  Convex optimization on graphs
%    gsp_demo_graph_tv       -  Graph TV demonstration
%    gsp_demo_wavelet_dn     -  Graph wavelets denoising
%    gsp_demo_learn_graph    -  Graph learning demonstration
%    gsp_demo_stationarity   -  Signal inpainting using stationarity
%
%  Graph learning
%    gsp_demo_learn_graph    - Demonstration of learning a graph from data
%    gsp_demo_learn_graph_large - Tutorial for graph learning using the GSPBox
%
%  Sparse approximation
%    gsp_demo_pyramid        -  Kron Pyramid applied to a signal
%
%  For help, bug reports, suggestions etc. please send email to
%  gspbox 'dash' support 'at' groupes 'dot' epfl 'dot' ch
%
%
%   Url: https://epfl-lts2.github.io/gspbox-html/doc/demos/Contents.html

% Copyright (C) 2013-2016 Nathanael Perraudin, Johan Paratte, David I Shuman.
% This file is part of GSPbox version 0.7.5
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.

% If you use this toolbox please kindly cite
%     N. Perraudin, J. Paratte, D. Shuman, V. Kalofolias, P. Vandergheynst,
%     and D. K. Hammond. GSPBOX: A toolbox for signal processing on graphs.
%     ArXiv e-prints, Aug. 2014.
% http://arxiv.org/abs/1408.5781

