#!/bin/bash

means=( "4e4" "5e4" "1e4" "2e4" )
stds=( "1e4" "5e3" "1e4" "2e4" )
model_name=$1
dataset_name=$2

for ((i=0;i<${#means[@]};++i))
do
	mean=${means[i]}
	std=${stds[i]}
	filename=${model_name}_${dataset_name}_N-${mean}-${std}_weights'/'
	log_name=${model_name}_${dataset_name}_N-${mean}-${std}.log
	mkdir $filename
	touch $log_name

	python3.6 train.py --blind=1 --batch_size=128 --saved=${filename} --mean=${mean} --std=${std} --log=${log_name} --model=${model_name} --dataset=${dataset_name}

	res_dir=${model_name}_${dataset_name}_N-${mean}-${std}
	mkdir $res_dir
	mv $log_name $res_dir
	mv $filename $res_dir
done