#!/bin/bash



means=( "4e3"  "2e4" "1e4" "1e4" )
stds=( "4e3" "4e3" "5e3" "1e4"  )
models=( "vgg19" "vgg16" "mobilenet" )

for ((j=0;j<${#models[@]};++j))
do
	model_name=${models[j]}
	for ((i=0;i<${#means[@]};++i))
	do
		mean=${means[i]}
		std=${stds[i]}
		log_name=${model_name}_imageNet_val_N-${mean}-${std}.log
		touch $log_name

		python3.6 val_model.py --blind=1 --batch_size=20 --mean=${mean} --std=${std} --model=${model_name} > ${log_name}

	done
done