# DarKnight: A Data Privacy Scheme for Training and Inference of Deep Neural Networks

## SGX Implementation Timing
### Requirements
##### Python Packges
Our implementation is based on [Slalom](https://github.com/ftramer/slalom). The package requirements are the same as Slalom code base.

```setup
  $ pip install -r slalom_n/requirements.txt
```
##### Intel SGX Requirements
Code in this folder requires a host processor with SGX enabled. Intel SGX drivers and Intel SGX SDK should all be installed properly. To install SGX driver, please refer [Driver](https://github.com/intel/linux-sgx-driver) for installation guide. To install SGX SDK please refer [SDK](https://github.com/intel/linux-sgx) for installation guide.
> Note that Intel DNNL for SGX should also be installed in Intel SDK. Please refer this [link](https://github.com/intel/linux-sgx/tree/master/external/dnnl) for installation guide.
### DarKnight Forward & Backward Pass timing

#### Baseline VGG16
```
  $ cd slalom_n
  $ make
  $ python -um python.slalom.scripts.test_vggEnclave
```

#### Darknight VGG16
```
  $ cd slalom_n
  $ make
  $ python3.6 -u -m python.slalom.scripts.verify_grads vgg_16 --batch_size=32 --blinding --use_sgx
```

#### Baseline MobileNetV2
```
  $ cd slalom_n
  $ make
  $ python -um python.slalom.scripts.test_mobileEnclave
```

#### Darknight MobileNetV2
```
  $ cd slalom_n
  $ make
  $ python -um python.slalom.scripts.mobileNet_transform
```

#### Baseline Resnet50
```
  $ cd slalom_n
  $ make
  $ python -um python.slalom.scripts.test_restnetEnclave
```

#### Darknight Resnet50
```
  $ cd slalom_n
  $ make
  $ python -um python.slalom.scripts.resnet_dark
```

#### Baseline Resnet152
```
  $ cd slalom_n
  $ make
  $ python -um python.slalom.scripts.test_restnetEnclave
```

#### Darknight Resnet152
```
  $ cd slalom_n
  $ make
  $ python -um python.slalom.scripts.resnet152_dark
```





