#include <iostream>
#include "tensorflow/core/framework/numeric_op.h"
#include "tensorflow/core/framework/op_kernel.h"
#include "tensorflow/core/framework/register_types.h"
#include "tensorflow/core/framework/tensor.h"
#include "tensorflow/core/framework/tensor_types.h"
#include "tensorflow/core/framework/common_shape_fns.h"
#include "tensorflow/core/common_runtime/threadpool_device.h"

#include "third_party/eigen3/unsupported/Eigen/CXX11/Tensor"
#include <dlfcn.h>

using namespace std;
using namespace tensorflow;

template <typename Device, typename T>
class BatchNormDarkOp : public OpKernel {
  public:
    explicit BatchNormDarkOp(OpKernelConstruction* context) : OpKernel(context) {
        OP_REQUIRES_OK(context, context->GetAttr("eid_low", &eid_low_));
        OP_REQUIRES_OK(context, context->GetAttr("eid_high", &eid_high_));
        lib_ = dlopen("App/enclave_bridge.so", RTLD_NOW);
        OP_REQUIRES(context, lib_ != NULL, errors::Unknown("Unable to load .so"));
        OP_REQUIRES_OK(context, context->GetAttr("act_mode", &act_mode_));
    }

    void Compute(OpKernelContext* context) override {
        const Tensor& input = context->input(0);
        const Tensor& means = context->input(1);
        const Tensor& skip_input = context->input(2);
        Tensor* output = nullptr;
        Tensor* act_out = nullptr;
        OP_REQUIRES_OK(context, context->allocate_output(0, input.shape(), &output));
        OP_REQUIRES_OK(context, context->allocate_output(1, input.shape(), &act_out));
        
        unsigned long int eid_ = (eid_high_ << 32) + eid_low_;

        typedef void(* batch_func) (unsigned long int, float*, float*, float*, float*, float*, int, const char*);
        dlerror();
        batch_func batch_norm = (batch_func) dlsym(lib_, "batchnormSp_dark");
        const char *dlsym_error = dlerror();
        OP_REQUIRES(context, !dlsym_error, errors::Unknown("loading of relu failed: ", dlsym_error));

        batch_norm(eid_,
                   (float*) output->flat<T>().data(),
                   (float*) input.flat<T>().data(),
                   (float*) means.flat<T>().data(),
                   (float*) skip_input.flat<T>().data(),
                   (float*) act_out->flat<T>().data(),
                   input.shape().dim_sizes()[0],
                   this->act_mode_.c_str()
                    );
    }
  private:
    void* lib_;
    std::string act_mode_;
    int64 eid_low_;
    int64 eid_high_;

};  // class BatchNormDarkOp

typedef Eigen::ThreadPoolDevice CPUDevice;

REGISTER_KERNEL_BUILDER(Name("BatchNormDark").Device(DEVICE_CPU), BatchNormDarkOp<CPUDevice, float>);

REGISTER_OP("BatchNormDark")
    .Attr("eid_low: int")
    .Attr("eid_high: int")
    .Attr("act_mode: string")
    .Input("inp: float")
    .Input("means: float")
    .Input("skip_input: float")
    .Output("output: float")
    .Output("act_src: float")
    .SetShapeFn([](::tensorflow::shape_inference::InferenceContext* c) {
        c->set_output(0, c->input(0));
        c->set_output(1, c->input(0));
        return Status::OK();
    });