#include <iostream>
#include "tensorflow/core/framework/numeric_op.h"
#include "tensorflow/core/framework/op_kernel.h"
#include "tensorflow/core/framework/register_types.h"
#include "tensorflow/core/framework/tensor.h"
#include "tensorflow/core/framework/tensor_types.h"
#include "tensorflow/core/framework/common_shape_fns.h"
#include "tensorflow/core/common_runtime/threadpool_device.h"

#include "third_party/eigen3/unsupported/Eigen/CXX11/Tensor"
#include <dlfcn.h>

using namespace std;
using namespace tensorflow;

template <typename Device, typename T>
class ResnetBottomOp : public OpKernel {
  public:
    explicit ResnetBottomOp(OpKernelConstruction* context) : OpKernel(context) {
        OP_REQUIRES_OK(context, context->GetAttr("eid_low", &eid_low_));
        OP_REQUIRES_OK(context, context->GetAttr("eid_high", &eid_high_));
        lib_ = dlopen("App/enclave_bridge.so", RTLD_NOW);
        OP_REQUIRES(context, lib_ != NULL, errors::Unknown("Unable to load .so"));
        OP_REQUIRES_OK(context, context->GetAttr("act_mode", &act_mode_));
    }

    void Compute(OpKernelContext* context) override {
        const Tensor& in_l = context->input(0);
        const Tensor& m_l  = context->input(1);
        const Tensor& in_r = context->input(2);
        const Tensor& m_r  = context->input(3);
        
        Tensor* output = nullptr;
        OP_REQUIRES_OK(context, context->allocate_output(0, in_l.shape(), &output));
        
        unsigned long int eid_ = (eid_high_ << 32) + eid_low_;

        typedef void(* botfunc) (unsigned long int, float*, float*, float*, float*, float*);
        dlerror();
        botfunc func = (botfunc) dlsym(lib_, "resnet_bottom_fwd");
        const char *dlsym_error = dlerror();
        OP_REQUIRES(context, !dlsym_error, errors::Unknown("loading of relu failed: ", dlsym_error));

        func(eid_,
                   (float*) in_l.flat<T>().data(),
                   (float*) m_l.flat<T>().data(),
                   (float*) in_r.flat<T>().data(),
                   (float*) m_r.flat<T>().data(),
                   (float*) output->flat<T>().data()
            );
    }
  private:
    void* lib_;
    std::string act_mode_;
    int64 eid_low_;
    int64 eid_high_;

};  // class ResnetBottomOp

typedef Eigen::ThreadPoolDevice CPUDevice;

REGISTER_KERNEL_BUILDER(Name("ResnetBottom").Device(DEVICE_CPU), ResnetBottomOp<CPUDevice, float>);

REGISTER_OP("ResnetBottom")
    .Attr("eid_low: int")
    .Attr("eid_high: int")
    .Attr("act_mode: string")
    .Input("left_in: float")
    .Input("right_in: float")
    .Input("mean_left: float")
    .Input("mean_right: float")
    .Output("output: float")
    .SetShapeFn([](::tensorflow::shape_inference::InferenceContext* c) {
      c->set_output(0, c->input(0));
      return Status::OK();
    });
    