#include <iostream>
#include "tensorflow/core/framework/numeric_op.h"
#include "tensorflow/core/framework/op_kernel.h"
#include "tensorflow/core/framework/register_types.h"
#include "tensorflow/core/framework/tensor.h"
#include "tensorflow/core/framework/tensor_types.h"
#include "tensorflow/core/framework/common_shape_fns.h"
#include "tensorflow/core/common_runtime/threadpool_device.h"

#include "third_party/eigen3/unsupported/Eigen/CXX11/Tensor"
#include <dlfcn.h>

using namespace std;
using namespace tensorflow;

template <typename Device, typename T>
class RensetBottomBackOp : public OpKernel {
  public:
    explicit RensetBottomBackOp(OpKernelConstruction* context) : OpKernel(context) {
        OP_REQUIRES_OK(context, context->GetAttr("eid_low", &eid_low_));
        OP_REQUIRES_OK(context, context->GetAttr("eid_high", &eid_high_));
        lib_ = dlopen("App/enclave_bridge.so", RTLD_NOW);
        OP_REQUIRES(context, lib_ != NULL, errors::Unknown("Unable to load .so"));
        OP_REQUIRES_OK(context, context->GetAttr("act_mode", &act_mode_));
    }

    void Compute(OpKernelContext* context) override {
        const Tensor& input = context->input(0);

        Tensor* grad_left  = nullptr;
        Tensor* grad_right = nullptr;
        OP_REQUIRES_OK(context, context->allocate_output(0, input.shape(), &grad_left));
        OP_REQUIRES_OK(context, context->allocate_output(1, input.shape(), &grad_right));
        
        unsigned long int eid_ = (eid_high_ << 32) + eid_low_;

        typedef void(* bottom_back) (unsigned long int, float*, float*, float*);
        dlerror();
        bottom_back bottom_back_func = (bottom_back) dlsym(lib_, "resnet_bottom_bwd");
        const char *dlsym_error = dlerror();
        OP_REQUIRES(context, !dlsym_error, errors::Unknown("loading of relu failed: ", dlsym_error));

        bottom_back_func(eid_,
                   (float*) grad_left->flat<T>().data(),
                   (float*) grad_right->flat<T>().data(),
                   (float*) input.flat<T>().data()
                );
    }
  private:
    void* lib_;
    std::string act_mode_;
    int64 eid_low_;
    int64 eid_high_;

};  // class RensetBottomBackOp

typedef Eigen::ThreadPoolDevice CPUDevice;

REGISTER_KERNEL_BUILDER(Name("RensetBottomBack").Device(DEVICE_CPU), RensetBottomBackOp<CPUDevice, float>);

REGISTER_OP("RensetBottomBack")
    .Attr("eid_low: int")
    .Attr("eid_high: int")
    .Attr("act_mode: string")
    .Input("grad_out: float")
    .Output("grad_left: float")
    .Output("grad_right: float")
    .SetShapeFn([](::tensorflow::shape_inference::InferenceContext* c) {
      c->set_output(0, c->input(0));
      c->set_output(1, c->input(0));
      return Status::OK();
    });