import torch
import torchvision.transforms as transforms
import torchvision.datasets as datasets
import numpy as np
import os

def cifar_loader(batch_size, is_train=True):
    normalize = transforms.Normalize(mean=[0.485, 0.456, 0.406],
                                     std=[0.229, 0.224, 0.225])

    data_set = datasets.CIFAR10(root='/home/yongqin/', train=is_train, transform=transforms.Compose([
        transforms.RandomHorizontalFlip(),
        transforms.RandomCrop(32, 4),
        transforms.ToTensor(),
        normalize,
    ]), download=True)
        
    train_loader = torch.utils.data.DataLoader(
        data_set,
        batch_size=batch_size, shuffle=True,
        num_workers=12, pin_memory=True)
    return train_loader
