import tensorflow as tf
import numpy as np

from python.slalom.mobileNetv2 import MobileNetV2 as MobileNetV2_sgx
from python.slalom.resnet_sp import ResNet50
from python.slalom.resnet_bias_sp import ResNet50 as ResNetBias
from python.slalom.global_sgx import sgxutils
import time
import keras.backend as K
from keras.losses import mean_squared_error as MSE

from tensorflow.python.framework import ops
from tensorflow.python.ops import array_ops
from tensorflow.python.ops import sparse_ops
import sys
@ops.RegisterGradient("BatchNormDark")
def _batchnorm_dark_grad(op, grad, grad1):
    act_src    = op.outputs[1]
    batch_src  = op.inputs[0]
    mean       = op.inputs[1]
    skip_input = op.inputs[2]

    res = sgxutils.batchnorm_dark_back(grad, batch_src, skip_input, act_src)

    grad_skip = res

    if (res.shape != skip_input.shape):
        grad_skip = skip_input


    return [res, mean, res]

def copy_resnet_data(bias_model, normal_model):
    weight = normal_model.layers[2].get_weights()[0]
    bias   = normal_model.layers[2].get_weights()[1]
    bias_model.layers[2].set_weights([weight])
    bias_model.layers[3].set_weights([bias])

    total_size = len(normal_model.layers)
    for idx in range(4, total_size-3):
        bias_model.layers[idx].copy_data(normal_model.layers[idx])

def main(args):
    config = tf.ConfigProto(log_device_placement=False)
    config.allow_soft_placement = True
    config.gpu_options.per_process_gpu_memory_fraction = 0.90
    config.gpu_options.allow_growth = True
    bm, um, gm, igm = sgxutils.fill_parameter(internal_batch_size=3)
    sgxutils.dnnl_init()
    batch_size = 15
    with tf.Session(config=config) as sess:
        
        with tf.device("/gpu:0"):
            input_tensor = tf.random_uniform((batch_size, 224, 224, 3), minval=-1000.0, maxval=1000.0, dtype=tf.float32)
            out_tensor = tf.random_uniform((batch_size, 1000), minval=-1000.0, maxval=1000.0, dtype=tf.float32)

            model_sgx = ResNet50(input_shape=(224, 224, 3), 
                                 weights=None, 
                                 classes=1000)

            print(model_sgx.summary())
            model_trans = ResNetBias(input_shape=(224, 224, 3), 
                                    weights=None, 
                                    classes=1000)
            K.get_session().run(tf.initialize_all_variables())
            copy_resnet_data(model_trans, model_sgx)
            total_size = len(model_sgx.layers)

            input_np  = sess.run(input_tensor, feed_dict={})
            y1        = sess.run(model_sgx.layers[total_size-4].output, feed_dict={model_sgx.input:input_np})
            y2        = sess.run(model_trans.layers[total_size-4].output, feed_dict={model_trans.input:input_np})
            print((y1 - y2).sum())


if __name__ == '__main__':
    import argparse
    parser = argparse.ArgumentParser()
    args = parser.parse_args()

    main(args)