from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

import python.slalom.keras_fix

import sys
import os
import copy 

import numpy as np
import tensorflow as tf
from tensorflow.python.client import timeline
from python.slalom.sgxdnn import model_to_json
from python.slalom.global_sgx import sgxutils

def relu(x):
    return x*(x>0)

sgxutils.dnnl_init()

relu_src = np.array([1, 1, 2, 2], dtype=np.int32)
sgxutils.setup_relu(relu_src)

relu_src = np.array([1, 1, 2, 2], dtype=np.int32)
sgxutils.setup_relu(relu_src)

src1 = tf.random_uniform((1, 1, 2, 2), minval=-100, maxval=100, dtype="float32")
src2 = tf.random_uniform((1, 1, 2, 2), minval=-100, maxval=100, dtype="float32")
grad1 = tf.random_uniform((1, 1, 2, 2), minval=-100, maxval=100, dtype="float32")
grad2 = tf.random_uniform((1, 1, 2, 2), minval=-100, maxval=100, dtype="float32")

r2 = sgxutils.slalom_relu_back(grad2, src2)
r1 = sgxutils.slalom_relu_back(grad1, src1)

ep1 = tf.multiply(tf.cast(tf.greater(src1, tf.constant([0.0])), tf.float32),  grad1)

with tf.Session("") as sess:
    for i in range(1):        
        got2= r2.eval()
        got1 = r1.eval()
        print(ep1.eval())

        
        
sgxutils.destroy()
