from python.slalom.global_sgx import sgxutils
import numpy as np
from numpy import random

import tensorflow as tf
import time


tf.logging.set_verbosity(tf.logging.INFO)
    tf.set_random_seed(0)

    with tf.Graph().as_default():



bm, um, gm, igm = sgxutils.fill_parameter(internal_batch_size=3)
sgxutils.dnnl_init(train_inside=0, internal_batch=3)
sgxutils.slalom_init(False, False, batch_size=33)

x_shape = (33, 4096*8)
s1, s2 = x_shape
x = random.rand(s1, s2).astype(np.float32) * 100. + 1000.
print(x.shape)



with tf.Session() as sess:
    res = sgxutils.slalom_blind_input(x)

cleared_res = um @ res.reshape([int(s1 / 3), 3, -1])
cleared_res = cleared_res.reshape(s1, s2)

print(x.shape, cleared_res.shape)

for i in range(11):
    idx = i * 3

    diff = cleared_res[idx] - x[idx]
    diff1 = cleared_res[idx+1] - x[idx+1]

    print(diff.mean(), diff.std())
    print(diff1.mean(), diff1.std())


sgxutils.destroy()

