
from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

import python.slalom.keras_fix

import sys
import os
import copy 

import numpy as np
import tensorflow as tf
from tensorflow.python.client import timeline
from keras import backend
from keras.layers import MaxPooling2D
from python import imagenet
from python.slalom.models import get_model
from python.slalom.quant_layers import transform_full, transform, build_blinding_ops, prepare_blinding_factors, get_all_linear_layers
from python.slalom.utils import Results
from python.slalom.sgxdnn import model_to_json, model_to_json_full
from python.slalom.global_sgx import sgxutils
from keras.models import Sequential

import pickle

os.environ['TF_CPP_MIN_LOG_LEVEL'] = '3'
os.environ["TF_USE_DEEP_CONV2D"] = '0'


def blind(x, y, a1, a2, b1, b2):
    return x*a1 + y*a2, x*b1 + y*b2

def unblind(x, y, a1, a2, b1, b2):
    return (b2*x-a2*y) / (a1*b2-b1*a2), (b1*x-a1*y) / (a2*b1 - a1*b2) 

    
def main(_):
    tf.logging.set_verbosity(tf.logging.INFO)
    tf.set_random_seed(1234)

    with tf.Graph().as_default():
        num_batches = args.max_num_batches
        batch_size = args.batch_size

        device = '/gpu:0'
        config = tf.ConfigProto(log_device_placement=False)
        config.allow_soft_placement = True
        config.gpu_options.per_process_gpu_memory_fraction = 0.90
        config.gpu_options.allow_growth = True

        quantize = True
        slalom = not args.no_slalom
        blinded = args.blinding 
        integrity = args.integrity
        simulate = args.simulate

        with tf.Session(config=config) as sess:
            with tf.device(device):
                model, model_info = get_model(args.model_name, batch_size, include_top=True, double_prec=False)
                model_sgx, model_info_sgx = get_model(args.model_name, batch_size, include_top=True, double_prec=False)
                modelq, model_info_q = get_model(args.model_name, batch_size, include_top=True, double_prec=False)
                model_base, model_infob = get_model(args.model_name, batch_size, include_top=True, double_prec=False)
                dataset_images, labels = imagenet.load_validation(
                args.input_dir, batch_size, preprocess=model_info['preprocess'])

            coord = tf.train.Coordinator()
            threads = tf.train.start_queue_runners(sess=sess, coord=coord)

            num_linear_layers = len(get_all_linear_layers(model))
            if blinded and not simulate:
                queues = [tf.FIFOQueue(capacity=num_batches + 1, dtypes=[tf.float32]) for _ in range(num_linear_layers)]
            else:
                queues = None

            with tf.device(device):
                modelq, linq, oq = transform_full(modelq, sgxutils=None, quantization=True)
                model_slalom, sq, oqs, = transform(model, log=False, quantize=True, verif_preproc=False,
                                                             slalom=False, slalom_integrity=False, slalom_privacy=False,
                                                             bits_w=model_info['bits_w'],
                                                             bits_x=model_info['bits_x'],
                                                             sgxutils=None, queues=None)

            
            len_slalom=len(model_slalom.layers)
            len_q = len(modelq.layers)
            print(len_slalom, len_q)
            assert(len_q == len_slalom)
            
            num_classes = np.prod(model.output.get_shape().as_list()[1:])    
            print_acc = (num_classes == 1000)
            res = Results(acc=print_acc)
            res_me = Results(acc=print_acc)
            run_options = tf.RunOptions(trace_level=tf.RunOptions.FULL_TRACE)
            run_metadata = tf.RunMetadata()
                            
            for i in range(num_batches):
                images, true_labels = sess.run([dataset_images, labels])
                if quantize:
                    images = np.round(2 ** model_info['bits_x'] * images).astype(np.float32)
                    print("bits_x: {}, input images: {}".format(model_info['bits_x'], np.sum(np.abs(images))))



                res.start_timer()
                res_me.start_timer()
                
                diff_array = []
                
                with tf.device(device):
                    prev_layer  = 0
                    value_me    = images
                    value_slalom=images
                    bp = 39
                    i = 0
                    for idx in range(len_q):
                        #if i == 3:
                        #    print("Input")
                        #    print(value_slalom[0][0][0][0],value_slalom[0][0][1][0], value_slalom[0][1][0][0], value_slalom[0][1][1][0])
                        #    print(value_me[0][0][0][0],value_me[0][0][1][0], value_me[0][1][0][0], value_me[0][1][1][0])
                        
                        value_slalom = sess.run(model_slalom.layers[idx].output, feed_dict={model_slalom.layers[idx].input: value_slalom,
                                                                      backend.learning_phase(): 0},
                                            options=run_options, run_metadata=run_metadata)                    
                        
                        value_me = sess.run(modelq.layers[idx].output, feed_dict={modelq.layers[idx].input: value_me,
                                                                                backend.learning_phase(): 0},
                                                  options=run_options, run_metadata=run_metadata)

                        print(modelq.layers[idx])
                        print("Output shape ", value_me.shape)
                        print("expected value vs original value")
                        
                        print(np.max(value_me), np.max(value_slalom))
                        
                        diff = np.sum(np.abs(value_slalom - value_me) > 10)
                        diff_array.append(diff)
                        print("diff val", diff)
                        if idx == 38:
                            print(model_slalom.layers[idx].activation, modelq.layers[idx].activation)
                        print("_________________________________________________")
                        i =  i + 1

                        

                            
                        
                        if idx >= bp:
                            break

                print("diff array content")
                print(diff_array)
                preds_me = np.reshape(value_me, (batch_size, -1))
                preds_slalom = np.reshape(value_slalom, (batch_size, -1))
                res.end_timer()
                res_me.end_timer()
                res_me.record_acc(preds_me, true_labels)
                res.record_acc(preds_slalom, true_labels)
            res.print_results()
            res_me.print_results()
            sys.stdout.flush()
            coord.request_stop()
            coord.join(threads)

        if sgxutils is not None:
            sgxutils.destroy()


if __name__ == '__main__':
    import argparse

    parser = argparse.ArgumentParser()

    parser.add_argument('model_name', type=str,
                        choices=['vgg_16', 'vgg_19', 'inception_v3', 'mobilenet', 'mobilenet_sep', 
                                 'resnet_18', 'resnet_34', 'resnet_50', 'resnet_101', 'resnet_152'])
    parser.add_argument('--input_dir', type=str,
                        default='../imagenet/',
                        help='Input directory with images.')
    parser.add_argument('--batch_size', type=int, default=8,
                        help='How many images process at one time.')
    parser.add_argument('--max_num_batches', type=int, default=2,
                        help='Max number of batches to evaluate.')
    parser.add_argument('--use_sgx', action='store_true')
    parser.add_argument('--no_slalom', action='store_true', help='only test GPU quantization')
    parser.add_argument('--blinding', action='store_true', help='add random blinding for privacy')
    parser.add_argument('--integrity', action='store_true', help='add integrity checks')
    parser.add_argument('--simulate', action='store_true')
    args = parser.parse_args()

    tf.app.run()
