
from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

import python.slalom.keras_fix

import sys
import os
import copy 

import numpy as np
import tensorflow as tf
from tensorflow.python.client import timeline
from keras import backend
from keras.layers import MaxPooling2D
from python import imagenet
from python.slalom.models import get_model
from python.slalom.quant_layers import transform_full, transform, build_blinding_ops, prepare_blinding_factors, get_all_linear_layers
from python.slalom.utils import Results
from python.slalom.sgxdnn import model_to_json, model_to_json_full
from python.slalom.global_sgx import sgxutils
from keras.models import Sequential

import pickle

os.environ['TF_CPP_MIN_LOG_LEVEL'] = '3'
os.environ["TF_USE_DEEP_CONV2D"] = '0'


def blind(x, y, a1, a2, b1, b2):
    return x*a1 + y*a2, x*b1 + y*b2

def unblind(x, y, a1, a2, b1, b2):
    return (b2*x-a2*y) / (a1*b2-b1*a2), (b1*x-a1*y) / (a2*b1 - a1*b2) 

    
def main(_):
    tf.logging.set_verbosity(tf.logging.INFO)
    tf.set_random_seed(0)

    with tf.Graph().as_default():
        num_batches = args.max_num_batches
        batch_size = args.batch_size

        device = '/gpu:0'
        config = tf.ConfigProto(log_device_placement=False)
        config.allow_soft_placement = True
        config.gpu_options.per_process_gpu_memory_fraction = 0.90
        config.gpu_options.allow_growth = True

        quantize = True
        slalom = not args.no_slalom
        blinded = args.blinding 
        integrity = args.integrity
        simulate = args.simulate

        with tf.Session(config=config) as sess:
            with tf.device(device):
                model, model_info = get_model(args.model_name, batch_size, include_top=True, double_prec=False)
                model_sgx, model_info_sgx = get_model(args.model_name, batch_size, include_top=True, double_prec=False)
                modelq, model_info_q = get_model(args.model_name, batch_size, include_top=True, double_prec=False)
                model_base, model_infob = get_model(args.model_name, batch_size, include_top=True, double_prec=False)
            dataset_images, labels = imagenet.load_validation(
                args.input_dir, batch_size, preprocess=model_info['preprocess'])

            coord = tf.train.Coordinator()
            threads = tf.train.start_queue_runners(sess=sess, coord=coord)

            num_linear_layers = len(get_all_linear_layers(model))
            if blinded and not simulate:
                queues = [tf.FIFOQueue(capacity=num_batches + 1, dtypes=[tf.float32]) for _ in range(num_linear_layers)]
            else:
                queues = None

            with tf.device(device):
                model_sgx, l_sgx_ops_in, loPout_sgx = transform_full(model_sgx, sgxutils=sgxutils, quantization=False)
                modelq, linq, oq = transform_full(modelq, sgxutils=None, quantization=False)


            print(modelq.summary())
            print(model_sgx.summary())

            print(type(model.layers))
            dtype = np.float32
            model_json, weights = model_to_json_full(sess, model_sgx)

            print(model_json)
            
            sgxutils.dnnl_init()
            sgxutils.load_model(model_json, weights, dtype=dtype, verify=False, verify_preproc=False)

            num_classes = np.prod(model.output.get_shape().as_list()[1:])    
            print_acc = (num_classes == 1000)
            res = Results(acc=print_acc)
            res_sgx = Results(acc=print_acc)
            run_options = tf.RunOptions(trace_level=tf.RunOptions.FULL_TRACE)
            run_metadata = tf.RunMetadata()

            sgxutils.slalom_init(integrity, (blinded and not simulate), batch_size)
            
            #if blinded and not simulate:
                #in_ph, zs, out_ph, queue_ops, temps, out_funcs = build_blinding_ops(model, queues, batch_size)

            def unblind(mixture, a1, a2, b1, b2):
                size = mixture.shape[0] >> 1
                res = None
                for i in range(size):
                    x = mixture[2*i]
                    y = mixture[2*i+1]
                    
                    xc = (b2*x-a2*y) / (a1*b2-b1*a2)
                    yc = (b1*x-a1*y) / (a2*b1-a1*b2)
                    if res is None:
                        res = np.array([xc, yc])
                    else:
                        res = np.concatenate((res, np.array([xc, yc])), axis=0)

                return res

            def blind(mixture, a1, a2, b1, b2):
                size=mixture.shape[0] >> 1
                res = None

                for i in range(size):
                    x = mixture[2*i]
                    y = mixture[2*i+1]
                    
                    x_b = x*a1 + y*a2
                    y_b = x*b1 + y*b2
                    if res is None:
                        res = np.array([x_b, y_b])
                    else:
                        res=np.concatenate((res, np.array([x_b, y_b])), axis=0)
                return res

            
            check_layer = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,14,16,18,20,22,24,26,29,31,32]
            target_layer= [0, 1, 2, 3, 5, 6, 7, 8,10,11,12,13,14,17,19,21,24,26,28,31,34,36,38]

            #check_layer =[32]
            #target_layer=[38]
            #test_layer = [(True, None)]
            max_idx     = [0, 0, 0, 3, 0, 6, 0, 0,10, 0, 0,14, 0, 0,18, 0, 0, 0]
            test_layer  = [(False, None),(False, None),
                           (True, "relu"),(False, None),
                           (True, "max"),(False, None),
                           (True, "relu"), (False, None),
                           (True, "max"), (False, None),
                           (True, "relu"), (False, None),
                           (True, "relu"),
                           (True, "max"), (True, "relu"),
                           (True, "relu"), (True, "max"),
                           (True, "relu"), (True, "relu"),
                           (True, "max"), (True, "relu"),
                           (True, "relu"), (True, "None")]
            assert(len(check_layer) == len(test_layer))

            
            
            for i in range(num_batches):
                images, true_labels = sess.run([dataset_images, labels])
                image_original = copy.deepcopy(images[0])
                original_image0 = copy.deepcopy(images[0])
                original_image1 = copy.deepcopy(images[1])

                if False:
                    images = np.round(2 ** model_info['bits_x'] * images).astype(np.float32)
                    print("bits_x: {}, input images: {}".format(model_info['bits_x'], np.sum(np.abs(images))))

                print("before blinded", images[0][0][0])
                
                images_blinded = sgxutils.slalom_blind_input(images)
                
                
                res.start_timer()
                res_sgx.start_timer()
                
                preds_sgx = sess.run(model_sgx.layers[32].output, feed_dict={model_sgx.input:images_blinded})
                answer = sess.run(model.output, feed_dict={model.input:images})
                preds_sgx = np.reshape(preds_sgx, (batch_size, -1))
                answer = np.reshape(answer, (batch_size, -1))

                print("diff num ", np.sum(np.abs(preds_sgx - answer) > 1))
                res.end_timer()
                res_sgx.end_timer()
                res_sgx.record_acc(preds_sgx, true_labels)
                res.record_acc(answer, true_labels)
            res.print_results()
            res_sgx.print_results()
            sys.stdout.flush()
            coord.request_stop()
            coord.join(threads)

        if sgxutils is not None:
            sgxutils.destroy()


if __name__ == '__main__':
    import argparse

    parser = argparse.ArgumentParser()

    parser.add_argument('model_name', type=str,
                        choices=['vgg_16', 'vgg_19', 'inception_v3', 'mobilenet', 'mobilenet_sep', 
                                 'resnet_18', 'resnet_34', 'resnet_50', 'resnet_101', 'resnet_152'])
    parser.add_argument('--input_dir', type=str,
                        default='../imagenet/',
                        help='Input directory with images.')
    parser.add_argument('--batch_size', type=int, default=8,
                        help='How many images process at one time.')
    parser.add_argument('--max_num_batches', type=int, default=2,
                        help='Max number of batches to evaluate.')
    parser.add_argument('--use_sgx', action='store_true')
    parser.add_argument('--no_slalom', action='store_true', help='only test GPU quantization')
    parser.add_argument('--blinding', action='store_true', help='add random blinding for privacy')
    parser.add_argument('--integrity', action='store_true', help='add integrity checks')
    parser.add_argument('--simulate', action='store_true')
    args = parser.parse_args()

    tf.app.run()
