
from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

import python.slalom.keras_fix

import sys
import os
import copy 

import numpy as np
import tensorflow as tf
from tensorflow.python.client import timeline
from keras import backend
from keras.layers import MaxPooling2D
from python import imagenet
from python.cifar10 import cifar_loader
from python.slalom.models import get_model
from python.slalom.quant_layers import transform_full, transform, ActivationF, build_blinding_ops, prepare_blinding_factors, get_all_linear_layers
from python.slalom.utils import Results
from python.slalom.sgxdnn import model_to_json, model_to_json_full
from python.slalom.global_sgx import sgxutils
from python.slalom.global_bias import bias_list
from keras.models import Sequential
from tqdm import tqdm


from keras.datasets import cifar10
from keras.losses import categorical_crossentropy as crossentroy

import pickle

os.environ['TF_CPP_MIN_LOG_LEVEL'] = '3'
os.environ["TF_USE_DEEP_CONV2D"] = '0'


def blind(x, y, a1, a2, b1, b2):
    return x*a1 + y*a2, x*b1 + y*b2

def unblind(x, y, a1, a2, b1, b2):
    return (b2*x-a2*y) / (a1*b2-b1*a2), (b1*x-a1*y) / (a2*b1 - a1*b2) 



def get_activation_input(model):
    acts = []
    for layer in model.layers:
        if isinstance(layer, ActivationF):
            acts.append(layer.input)
            print(layer.input)
    return acts

def main(_):
    tf.logging.set_verbosity(tf.logging.INFO)
    tf.set_random_seed(0)


    with tf.Graph().as_default():
        num_batches = args.max_num_batches
        batch_size = args.batch_size

        device = '/gpu:0'
        config = tf.ConfigProto(log_device_placement=False)
        config.allow_soft_placement = True
        config.gpu_options.per_process_gpu_memory_fraction = 0.90
        config.gpu_options.allow_growth = True

        quantize = True
        slalom = not args.no_slalom
        blinded = args.blinding 
        integrity = args.integrity
        simulate = args.simulate
        train_loader = cifar_loader(batch_size, True)
        val_loader  = cifar_loader(batch_size, False)
        print(len(train_loader), len(val_loader))
        with tf.Session(config=config) as sess:
            with tf.device(device):
                model_base, model_info_sgx = get_model(args.model_name, batch_size, include_top=True, double_prec=False, class_num=10, pre_trained=False, h=64)
                model_base2, model_info  = get_model(args.model_name, batch_size, include_top=True, double_prec=False, class_num=10, pre_trained=False, h=64)
                
                for layer_idx, layer in enumerate(model_base.layers):
                    weights = layer.get_weights
                    if layer.trainable is True:
                        model_base2.layers[layer_idx].set_weights(layer.get_weights())            
                        
            
            coord = tf.train.Coordinator()
            threads = tf.train.start_queue_runners(sess=sess, coord=coord)


            
            with tf.device(device):    
                model_sgx, l_sgx_ops_in, loPout_sgx = transform_full(model_base, sgxutils=sgxutils, quantization=False)
                model_tar, l_tar_ops_in, loPout_tar = transform_full(model_base2, sgxutils=None, quantization=False)


            # remove the loss function
            model_sgx.pop()
            model_tar.pop()
            print(len(model_tar.layers))
            print(len(model_sgx.layers))
            act_input_tar = get_activation_input(model_tar)
            act_input_sgx = get_activation_input(model_sgx)

            y_sgx = tf.placeholder(shape=(batch_size, 1), dtype='float32')
            y_tar = tf.placeholder(shape=(batch_size, 1), dtype='float32')
            loss_sgx_fn = crossentroy(y_sgx, model_sgx.output)
            loss_tar_fn = crossentroy(y_tar, model_tar.output)
            gradients_sgx = backend.gradients(loss_sgx_fn, act_input_sgx)
            gradients_tar = backend.gradients(loss_tar_fn, act_input_tar)
            last_grad_sgx = backend.gradients(loss_sgx_fn, model_sgx.layers[32].input)[0]
            last_grad_tar = backend.gradients(loss_tar_fn, model_tar.layers[37].input)[0]
            #print(type(model.layers))
            dtype = np.float32
            model_json, weights = model_to_json_full(sess, model_sgx)
            print(model_json)
            sgxutils.dnnl_init()
            sgxutils.load_model(model_json, weights, dtype=dtype, verify=False, verify_preproc=False)

            num_classes = np.prod(model_sgx.output.get_shape().as_list()[1:])    
            print_acc = (num_classes == 10)
            res = Results(acc=print_acc)
            res_sgx = Results(acc=print_acc)
            run_options = tf.RunOptions(trace_level=tf.RunOptions.FULL_TRACE)
            run_metadata = tf.RunMetadata()
            #gradients_sgx.append(loss_sgx_fn)
            sgxutils.slalom_init(integrity, (blinded and not simulate), batch_size)
            average_loss = 0.0
            i = 1
            with tf.device(device):
                for image, target in tqdm(train_loader):
                    image = image.permute(0, 2, 3, 1).numpy()
                    target= target.reshape(batch_size, 1).numpy()
                    image  = sgxutils.slalom_blind_input(image)
                    print(image.shape)
                    #y_sgx = sess.run(model_sgx.output, feed_dict={model_sgx.input: image})
                    #y_tar = sess.run(model_tar.output, feed_dict={model_tar.input:image})

                    gradients_sgx_val = sess.run(gradients_sgx, feed_dict={model_sgx.input: image, y_sgx:target})
                    gradients_tar_val = sess.run(gradients_tar, feed_dict={model_tar.input: image, y_tar:target})
                    for res_idx, res in enumerate(gradients_sgx):
                        #print(gradients_sgx[res_idx].shape, gradients_tar[res_idx].shape)
                        print((gradients_sgx_val[res_idx] - gradients_tar_val[res_idx]).sum())
                    #for idx in range(len(gradients)-1):
                    #    backend.update_sub(trainable_weights_sgx[idx], gradients[idx] * 1e-2)
                    #print(image.shape)
                    if i >= 2:
                        break
                    
                    i += 1

            sys.exit(0)
            print(average_loss)
            
                
            # loss functions                                                                                              
            y_sgx = tf.placeholder(shape=(batch_size, 10), dtype='float32')
            
            loss_sgx_fn = MSE(y_sgx, model_sgx.output)
            
            
            gradients_tar = backend.gradients(loss_tar_fn, trainable_weights_tar)
            sys.exit(0)            
            
            for i in range(num_batches):
                
                
                sys.exit(0)
                preds_sgx = np.reshape(cleared_sgx, (batch_size, -1))
                preds = np.reshape(prev_value, (batch_size, -1))
                #res.end_timer()
                res_sgx.end_timer()
                res_sgx.record_acc(preds_sgx, true_labels)
                #res.record_acc(preds, true_labels)
            #res.print_results()
            res_sgx.print_results()
            sys.stdout.flush()
            coord.request_stop()
            coord.join(threads)

        if sgxutils is not None:
            sgxutils.destroy()


if __name__ == '__main__':
    import argparse

    parser = argparse.ArgumentParser()

    parser.add_argument('model_name', type=str,
                        choices=['vgg_16', 'vgg_19', 'inception_v3', 'mobilenet', 'mobilenet_sep', 
                                 'resnet_18', 'resnet_34', 'resnet_50', 'resnet_101', 'resnet_152'])
    parser.add_argument('--input_dir', type=str,
                        default='../imagenet/',
                        help='Input directory with images.')
    parser.add_argument('--batch_size', type=int, default=8,
                        help='How many images process at one time.')
    parser.add_argument('--max_num_batches', type=int, default=2,
                        help='Max number of batches to evaluate.')
    parser.add_argument('--use_sgx', action='store_true')
    parser.add_argument('--no_slalom', action='store_true', help='only test GPU quantization')
    parser.add_argument('--blinding', action='store_true', help='add random blinding for privacy')
    parser.add_argument('--integrity', action='store_true', help='add integrity checks')
    parser.add_argument('--simulate', action='store_true')
    args = parser.parse_args()

    tf.app.run()
