import numpy as np

def unblind(mixture, a1, a2, b1, b2):
    size = mixture.shape[0] >> 1
    res = None
    for i in range(size):
        x = mixture[2*i]
        y = mixture[2*i+1]
        
        xc = (b2*x-a2*y) / (a1*b2-b1*a2)
        yc = (b1*x-a1*y) / (a2*b1-a1*b2)        
        if res is None:
            res = np.array([xc, yc])
        else:
            res = np.concatenate((res, np.array([xc, yc])), axis=0)

    return res


def blind(mixture, a1, a2, b1, b2):
    size=mixture.shape[0] >> 1
    res = None
    
    for i in range(size):
        x = mixture[2*i]
        y = mixture[2*i+1]
    
        x_b = x*a1 + y*a2
        y_b = x*b1 + y*b2
        if res is None:
            res = np.array([x_b, y_b])
        else:
            res=np.concatenate((res, np.array([x_b, y_b])), axis=0)
    return res


for i in range(100):
    mixture=np.random.uniform(low=-100.0, high=100.0, size=(4, 1, 1, 1))
    blinded = blind(mixture, 12.0, 4.3, 1.1, 4.4)
    cleared = unblind(blinded, 12.0, 4.3, 1.1, 4.4)
#    print(12.0, 4.3, 1.1, 4.4)
    
#    print(mixture.flatten(), "\n", blinded.flatten(), "\n", cleared.flatten())

    res = np.sum(np.abs(mixture-cleared))

    if (res > 10):
        print("unblinded error")
        sys.exit(-1)
