# Diff_QEP
Solving and Learning Differential Equations with Variational Q-Exponential Processes

## Sample Codes

**requirements**

- [PyTorch](https://pytorch.org)
- [GPyTorch](https://gpytorch.ai)

* Folders *

- GPyTorch: contains modified files for Q-Exponential processes
- util: sample_points.py for generating collocation points
- demo:
	* diff_func.py: definition of Rosenbrock and Rastriin
	* demo_GP_diff2d.py: GP model with derivative information
	* demo_QEP_diff2d.py: QEP model with derivative information (q=2 is same as demo_GP_diff2d.py)
- eikonal:
	* eikonal_CHFD.py: solving Eikonal equation with finite difference method
	* eikonal_PDE.py: class definition providing PDE mapping (lhs_f), distribution propagation, and utilities
	* eikonal_QEP_NGD.py: solving Eikonal equation with variational QEP (q=2.0 for GP)

## How to run

install **requirements**, then run:

`python demo_GP_diff2d.py` and `python demo_QEP_diff2d.py` to generate Figure 1

`python eikonal_CHFD.py` and `python eikonal_QEP_NGD.py x` with `x=0.8, 1.0, 1.5, 2.0` to generate Figure 2