import os
import torch

device = torch.device("cuda" if torch.cuda.is_available() else "cpu")

env = os.environ

try:
    trial = int(env["trial"])
except KeyError:
    trial = 1

try:
    n = int(env["n"])
except KeyError:
    n = 3
assert 2 <= n <= 10

try:
    m = int(env["m"])
except KeyError:
    m = 2
assert 2 <= m < n

try:
    seed = int(env["seed"])
except KeyError:
    seed = 0

try:
    torch_seed = int(env["tseed"])
except KeyError:
    torch_seed = 0

try:
    shape_n = int(env["shape"])
except KeyError:
    shape_n = 20

torch.manual_seed(torch_seed)

distribution_size = 5

task = env["task"]
assert task in ["s4multi", "manual"]

target = "mv"
supervised_steps = 0
unsupervised_steps = 20

try:
    sample_size = int(env["sample"])
except KeyError:
    sample_size = 100000

fingerprint = f"device={device} n={n} m={m} seed={seed} tseed={torch_seed} trial={trial} dsize={distribution_size} target={target} supervised_steps={supervised_steps} unsupervised_steps={unsupervised_steps} task={task} sample_size={sample_size} shape={shape_n}"
print("RESULT", fingerprint)
