import os
import torch

device = torch.device("cuda" if torch.cuda.is_available() else "cpu")

env = os.environ

try:
    trial = int(env["trial"])
except KeyError:
    trial = 1

try:
    n = int(env["n"])
except KeyError:
    n = 2
assert 2 <= n <= 10

try:
    seed = int(env["seed"])
except KeyError:
    seed = 0

try:
    torch_seed = int(env["tseed"])
except KeyError:
    torch_seed = 0

try:
    shape_n = int(env["shape"])
except KeyError:
    shape_n = 20

torch.manual_seed(torch_seed)

try:
    distribution_name = env["dname"]
    distribution_size = None
    assert distribution_name in [
        "saturn",
        "jupiter",
        "mars",
        "sol",
        "venus",
        "mercury",
        "luna",
        "worst10",
        "worst100",
    ]
except KeyError:
    distribution_name = None
    distribution_size = int(env["dsize"])

try:
    if int(env["dbinary"]) == 1:
        dbinary = True
    else:
        dbinary = False
except KeyError:
    dbinary = False

task = env["task"]
assert task in ["s4", "s4gan", "manual", "other"]

if task in ["s4", "s4gan"]:
    target = env["target"]
    assert target in ["vv", "ivv", "mv"]
    supervised_steps = int(env["super"])
    unsupervised_steps = int(env["unsuper"])
else:
    target = None
    supervised_steps = None
    unsupervised_steps = None

try:
    sample_size = int(env["sample"])
except KeyError:
    sample_size = 100000

fingerprint = f"device={device} n={n} seed={seed} tseed={torch_seed} trial={trial} dname={distribution_name} dsize={distribution_size} target={target} supervised_steps={supervised_steps} unsupervised_steps={unsupervised_steps} task={task} sample_size={sample_size} shape={shape_n} dbinary={dbinary}"
print("RESULT", fingerprint)
