import distribution
import random
import manual
from settings import n, seed, distribution_name, distribution_size, task, trial
import story4


random.seed(seed)
if distribution_name is not None:
    distribution_database = {
        "saturn": distribution.saturn,
        "jupiter": distribution.jupiter,
        "mars": distribution.mars,
        "sol": distribution.sol,
        "venus": distribution.venus,
        "mercury": distribution.mercury,
        "luna": distribution.luna,
        "worst100": distribution.worst100,
        "worst10": distribution.worst10,
    }
    d = distribution_database[distribution_name]
else:
    d = distribution.GridDistribution(size=distribution_size, seed=seed, binary=False)

if task == "manual":
    print(manual.myerson_ignore_correlation(d))
    if n == 2:
        print("AMD", manual.AMD(d, 100))
    print("greedy", manual.greedy(d))
    print("snd", manual.search_second_price_revenue(d))
elif task == "s4":
    for t in range(trial):
        print(f"trial {t}/{trial}")
        random.seed(t)
        story4.train(d)
elif task == "s4gan":
    d = manual.find_worst_distribution(d)
    print(manual.myerson_ignore_correlation(d))
    if n == 2:
        print("AMD", manual.AMD(d, 100))
    print("greedy", manual.greedy(d))
    print("snd", manual.search_second_price_revenue(d))
    story4.train(d)
else:
    assert task == "other"
    print("verify greedy", d.verify_greedy())
