

This repository contains a collection of numerical methods and deep learning models for solving partial differential equations (PDEs). The codebase is organized into three main sections: PDE problems, ablation studies, and benchmarking.

## Directory Structure

```
BAROM_codes/
├── Ablation_study/
├── PDE_C_with_control_input/
├── PDE_P_without_control_input/
├── BenchmarkingEBCROM-v3-CDF.py
├── BenchmarkingEBCROM-v3-hdl.py
├── BenchmarkingEBCROM-v3-RF.py
└── Benchmarking_Noatten.py
```

  - **`Ablation_study/`**: Contains scripts for model ablation studies, designed to analyze the performance impact of different model components.
  - **`PDE_C_with_control_input/`**: Includes scripts for dataset generation, model training, and validation for PDE problems with control inputs.
  - **`PDE_P_without_control_input/`**: Includes scripts for dataset generation, model training, and validation for PDE problems without control inputs.
  - **`Benchmarking*.py`**: A set of scripts for benchmarking various models and scenarios.

## Features

### 1\. PDE Dataset Generation

  - **`generate_datasets_PDE_P.py`**: Generates datasets for Advection, Euler, Burgers, and Darcy equations without control inputs.
  - **`generate_integral_feedback_datasets.py`**: Generates datasets for convection-diffusion, reaction-diffusion, and heat equations with integral feedback control.

### 2\. Model Implementations

The repository includes implementations of several models:

  - **BAROM**: An attention-based reduced-order model.
  - **BENO**: A neural operator inspired by the boundary element method.
  - **GNOT**: Graph Neural Operator.
  - **LNO**: Latent Neural Operator.
  - **LNS-AE**: Latent space autoencoder.
  - **POD-DL-ROM**: A deep learning-based reduced-order model.
  - **SPFNO**: A variant of the Fourier Neural Operator.
  - **Unisolver**: A universal solver.

### 3\. Ablation Studies

  - **`BAROM_fixedlifting.py`**: An ablation study script that uses fixed linear interpolation for the U\_B embedding.
  - **`BAROM_Noattn.py`**: Conducts an ablation study on the BAROM model without the attention mechanism.
  - **`BAROM_Random_pod.py`**: An ablation study script that uses random orthogonal initialization for Phi instead of POD.

### 4\. Benchmarking

  - **`Benchmarking*.py`**: Provides a series of benchmarking scripts to evaluate the performance of different models on specific datasets.

## Usage

1.  **Generate Datasets**:

      * Run `generate_datasets_PDE_P.py` or `generate_integral_feedback_datasets.py` to create the required datasets.
      * Example command:
        ```bash
        python BAROM_codes/PDE_P_without_control_input/generate_datasets_PDE_P.py --dataset advection --num_samples 10000 --nx 128 --nt 600 --T 2 --num_controls 0 --output_dir ./datasets_full
        ```

2.  **Train Models**:

      * Each model folder contains a `FULL.py` script or similar for training and validation.
      * Example command:
        ```bash
        python BAROM_codes/PDE_P_without_control_input/ROM_FULL_task1.py --datatype advection
        ```