# Variance Reduced Meta-Learning via Laplace Approximation

# Setup
The code has been created using `Python 3.9` and `torch 2.0.1`, this is mostly required to utilize `vmap` for parallel computations of the Hessian. 
Run 
```
pip install -r requirements.txt
``` 
to install further necessary packages. 

# Datasets
The data can be found in the `data` directory. Due to size limits, we have not included MiniImagenet, but the files can be found at `https://github.com/y2l/mini-imagenet-tools`.a

# Training

The models can be trained by running:

```
python main.py --model_type {MODEL} --dataset {DATASET} --n_s {SUPPORT_SIZE} --ambient {CONTEXT_DIM} --degrees {DEGREES_FOR_POLYNOMIAL}

```

For the models and datasets, we have the following options:
```
MODEL_TYPE = [lava, cavia]
DATASET=[sine, poly, spring, pendulum, deformable, omnipush]
```

For example, to run the `sine` experiment:

```
python main.py --model_type lava --dataset sine --n_s 10 --ambient 2
```

Training will create a `checkpoints` directory where models and results are saved. Specifically the files `results_train.pkl` and `results_test.pkl` will contain model performances and computational time for each epoch. Tensorboard files are further saved in the `logs` directory. 
