# PyTorch implementation of Meta Generative Regularization 
## Requirements
### Software Requirements
* CUDA >= 11.4
### Hardware Requirements
* GPUs >= Tesla A100 with 40 GB VRAM x 1
### Python Requirements
* Please see `pyproject.toml`

## Preparations
Here, we describe the preparation for the experiments on StanfordCars.
You can use other datasets by modifying the preparation scripts.
### Target Datset: StanfordCars
  1. Download the dataset from [here](https://ai.stanford.edu/~jkrause/cars/car_dataset.html) including `{train,test}_annos.npz`
  2. Install the dataset into `./data/StanfordCars`
  3. Run the preparation script as follows:
  ```sh
  cd ./data/StanfordCars/
  python3 ../script/split_train_test.py
  ```

## Samples of experiments
### Train main models by MGR (We plan to provide the pretrained GANs after acceptance)
* Required: Pre-trained StyleGAN2-ADA weights (sorry for not providing due to the large file size)
  - In our experiments, we used [official implementation](https://github.com/NVlabs/stylegan2-ada-pytorch) and default setting of 256x256 images for training GANs
  - We assume the pre-trained weights is in `pretrained/stylegan2ada/cars`


```sh
python3 main/train_mps.py --config_path config/01_multi-dataset/mgr/cars.yaml
```