# Statistical Test for Diffusion Model-based Anomaly Detection by Diffusion Model
This pacakge is the implementation of the paper "Statistical Test for Diffusion Model-based Anomaly Detection by Diffusion Model" for experiments.

## Installation & Requirements
This pacakage has the following dependencies:
- Python (version 3.10.0 or higher)
- numpy (1.26.0 or higher)
- matplotlib (3.9.0 or higher)
- torch  (2.1.0 or higher)
- sicore (version 2.2.0 or higher)
- scipy (1.11.0 or higher)
- onnx (1.16.0 or higher)
- onnxsim (0.4.0 or higher)
- omegaconf (2.3.0 or higher)

Please install these dependencies by pip.
```
pip install numpy
pip install matplotlib
pip install sicore
pip install scipy
pip install torch
pip install onnx
pip install onnxsim
pip install tqdm
pip install omegaconf
```

## Reproducibility
You can reproduce the figures by running following code.
The results will be saved in "/results/figures" folder.

To reproduce the results, please see the following instructions after installation step.
The results will be saved in "./results" folder as pickle file.

```
./results
├── corr
│   ├── fpr
│   │   ├── corr_size8_signal0_seed0.pickle
│   │   ├── corr_size8_signal0_seed1.pickle 
│   │   ├── ...
│   ├── power
│   │   ├── corr_size64_signal1_seed0.pickle
│   │   ├── corr_size64_signal1_seed1.pickle
│   │   ├── ...
├── iid
│   ├── fpr
│   │   ├── iid_size8_signal0_seed0.pickle
│   │   ├── iid_size8_signal0_seed1.pickle
│   │   ├── ...
│   ├── power
│   │   ├── iid_size64_signal1_seed0.pickle
│   │   ├── iid_size64_signal1_seed1.pickle
│   │   ├── ...
├── robust
│   ├── fpr
│   │   ├── EMG_size16_distance0.001_seed0.pickle
│   │   ├── EMG_size16_distance0.001_seed1.pickle
│   │   ├── ...
```

You can reproduce the experiments by running the following commands.

For indipendent noise (type I error rate experiment).
```
sh fpr_iid_expertiment.sh
```

For indipendent noise (power experiment).
```
sh power_iid_expertiment.sh
```

For correlation nosie (type I error rate experiment).
```
sh fpr_corr_expertiment.sh
```

For correlation noise (power experiment).
```
sh power_corr_expertiment.sh
```

For robustness (type I error rate experiment).
```
sh fpr_robust_expertiment.sh
```

Note that, in the `sh` file, the number of cpu cores to be used is specified by `workers` option. Please change it according to your environment.

### Plot the results
To plot the results, please run the following code.
In the "./plots/figures/syn" folder, the figures will be saved.
```
python plot_results.py
python plot_probability_density.py
```