#!/bin/bash

EXPERIMENT_SCRIPT=${EXPERIMENT_SCRIPT:-"source/experiment.py"}

for category in "iid"; do
    for size in 8 16 32 64; do
        for seed in {0..9}; do
            if [ $size -eq 8 ]; then
                iter=300
            else
                iter=120
            fi
            python $EXPERIMENT_SCRIPT \
                --category $category \
                --size $size \
                --signal 0.0 \
                --workers 96 \
                --iter $iter \
                --seed $seed \
                --distance 0
        done
    done
done