#!/bin/bash

EXPERIMENT_SCRIPT=${EXPERIMENT_SCRIPT:-"source/experiment.py"}

for category in "iid"; do
    for size in 64; do
        for signal in 1.0 2.0 3.0 4.0; do
            for seed in {0..9}; do
                python $EXPERIMENT_SCRIPT \
                    --category $category \
                    --size $size \
                    --signal $signal \
                    --workers 96 \
                    --iter 110 \
                    --seed $seed \
                    --distance 0
            done
        done
    done
done