import math


class RoutePlan(object):
    # paths: {(start_view_id, end_view_id): {"next": next_view_id, "angles":[(j1, h1, e1), (j2, h2, e2)....]}}
    # graphs: [{view_id: {neigh_view_id1: [(j1, h1, e1), ..], ..}, ..}, ..]
    @staticmethod
    def floyd(graph):
        """
        :param graph:
        :return:
        """
        distance, path = {}, {}
        view_ids = list(graph.keys())
        # ------ one-hot / initialization -------
        for i in view_ids:
            for j in view_ids:
                if j in graph[i]: distance[(i, j)], path[(i, j)] = graph[i][j][0][3], {"next": j, "angles": graph[i][j]}
                elif i == j: distance[(i, j)], path[(i, j)] = 0, {"next": j}
                else: distance[(i, j)] = math.inf
        # ------ floyd --------
        for k in view_ids:  # mid-node
            for i in view_ids:  # start node
                for j in view_ids:  # end node
                    if distance[(i, k)] + distance[(j, k)] < distance[(i, j)]:
                        distance[(i, j)] = distance[(i, k)] + distance[(j, k)]
                        distance[(j, i)] = distance[(i, k)] + distance[(j, k)]
                        path[(i, j)] = path[(i, k)]
                        path[(j, i)] = path[(j, k)]
        return path
