
class Param(object):
    lr = 0.001
    epoch = 20000
    batch_size = 50  # 50， 250

    voc_size = 1 + 26  # first token for padding
    emb_size = 128 # origin 64
    sent_len = 12  # orgin 6
    # cand_len = 10
    max_turns = 15  # max turn of dialogue
    reward = 1
    top_k = 5

    gamma = 0.09

    max_num_node = 350  # 348
    max_path_img_num = 6
    # max_neigh_num = min(cand_len - 1, 13)
    max_neigh_num = 13
    max_history_len = 100
    codec_type = "Transformer"

    trans_nhead = 8
    trans_feedforward = 64
    trans_dropout = 0.2
    trans_layernum = 1

    is_print_case = True
    is_add_stop_to_msg = False

    # sample_graph_method = "breadth first"  # "depth first" or "random"
    sample_graph_method = "random"
    msg_mode = "variable"
    # process = "localization"
    process = "navigation"   # localization, navigation, navigation-only
    is_spread_token = True  # original one does not spread obs with only one token to represent obs
    is_output_msg0 = True
    is_all_speak = False
    is_all_no_speak = False

    tokens = {"<msg A>": {"pos": 0,  # index of special tokens
                          "size": voc_size,
                          "start pos": 4,
                          "end pos": 4 + voc_size - 1,  # close form
                          "content": ["{0:02d}".format(i) for i in range(voc_size)]},
              "<msg B>": {"pos": 1,
                          "size": voc_size,  # same with msg A
                          "start pos": 4,
                          "end pos": 4 + voc_size - 1,
                          "content": ["{0:02d}".format(i) for i in range(voc_size)]},
              "<phy act>": {"pos": 2,
                            "size": 4,  # for localization task, there are 4 acts
                            "start pos": 4 + voc_size,
                            "end pos": 7 + voc_size,
                            "content": ["turn left", "turn right", "turn up", "turn down"]},
              "<continue>": {"pos": 3,
                             "size": 2,
                             "start pos": 8 + voc_size,
                             "end pos": 9 + voc_size,
                             "content": ["stop", "continue"]}}
    tokens_list = ["<msg A>", "<msg B>", "<phy act>", "<continue>"] + tokens["<msg A>"]["content"] + \
                  tokens["<phy act>"]["content"] + tokens["<continue>"]["content"]

    train_scan_file = "train_scans.txt"
    val_scan_file = "val_unseen_scans.txt"
    test_scan_file = ""
    connect_dir = "connectivity"
    graph_dir = "graph_distance"
    feature_dir = "features"
    obs_encode_model_a_pth = "agentA_encoder.pth"
    obs_encode_model_b_pth = "agentB_encoder.pth"
    
    loc_out_model_pth = "loc_models"
    nav_out_model_pth = "nav_models"
    guide_out_model_pth = "guide_models"
    