## Privately Learning from Graphs

### Environment
```
conda create -n pyvacy python=3.11
pip install torch==2.1.2 torchvision==0.16.2 torchaudio==2.1.2 --index-url https://download.pytorch.org/whl/cu118
pip install transformers==4.39.3
pip install sentencepiece
pip install peft
pip install datasets
pip install evaluate
pip install opacus
pip install wandb
pip install pandas
pip install scikit-learn
```

To use Jupyter NoteBook

```
conda install ipykernel
ipython kernel install --user --name=pyvacy
```

### Commands

non-private fine-tuning on relation data

```
bash lp_train_galm.sh $GPU_ID $DATASET $BATCH_SIZE $MODEL
bash lp_train_galm.sh 0 sports 128 large
```

fine-tuning on relational data with DP

```
bash lp_train_pvgalm.sh $GPU_ID $DATASET $EPSILON $NOISE_SCALE $CLIPPING_NORM $BATCH_SIZE 
bash lp_train_pvgalm.sh 0 mag_us -1 0.433 1 64
```

few-shot relation prediction

```
bash lp_train_pvgalm_fewshot.sh $GPU_ID $DATASET $BATCH_SIZE
bash lp_train_pvgalm_fewshot.sh 0 cloth 16
```

few-shot entity classification

```
bash nc_train_galm.sh $GPU_ID $DATASET $BATCH_SIZE
bash lp_train_pvgalm_fewshot.sh 0 mag_cn 128
```

### Datasets
Please follow the description in Appx. C to obtain the MAG and the AMAZ datasets.