import pathlib

from tqdm import tqdm
from concurrent import futures
import subprocess as sp


def convert(mp4_file_path):
    avi_file_path = str(mp4_file_path).replace(".mp4", ".avi").replace("k400", "k400_avi")
    args = ' '.join(['ffmpeg', '-y', '-loglevel', 'error',
                     '-i', str(mp4_file_path),  # Specify the input
                     '-c:v', 'mpeg4',
                     '-filter:v', '\"scale=min(iw\,(256*iw)/min(iw\,ih)):-1\"',
                     '-b:v', '512k',
                     avi_file_path])
    proc = sp.Popen(args, stdout=sp.PIPE, stderr=sp.PIPE, shell=True, universal_newlines=True, encoding='ascii')
    stdout, stderr = proc.communicate()
    if proc.returncode != 0:
        raise ValueError(f"Video corrupted: {stderr}")

    return "Success"


if __name__ == "__main__":
    root_path = pathlib.Path("/PATH/TO/ROOT/DIRECTORY/")
    
    mp4_file_paths = list(root_path.rglob("*.mp4"))
    print("Found videos:", len(mp4_file_paths))
    with futures.ProcessPoolExecutor(max_workers=4) as executor:
        # Start the load operations and mark each future with its URL
        future_to_video = {executor.submit(convert, mp4_file_path): mp4_file_path for mp4_file_path in mp4_file_paths}
        for future in tqdm(futures.as_completed(future_to_video), total=len(mp4_file_paths)):
            try:
                result = future.result()
                print(result)  # or log the result
            except Exception as e:
                print(f"Conversion failed: {e}")
