# This file contains various helper generic functions
import tensorflow as tf

# Tensor Flow settings
gpus = tf.config.experimental.list_physical_devices('GPU')
tf.compat.v1.ConfigProto().gpu_options.allow_growth = True
#tf.config.experimental.set_memory_growth(gpus[0], True)






def approximate_grad_norm(images, labels, model,loss_obj, JL_dim = 1):
    # 'reduction' for loss_obj should be set to tf.keras.losses.Reduction.NONE. For example 
    # loss_obj = tf.keras.losses.CategoricalCrossentropy(from_logits=True, reduction=tf.keras.losses.Reduction.NONE)

    grad_norm = 0
    
    for i in range(JL_dim):
        v=[tf.random.normal(w.shape) for w in model.trainable_variables]
        with tf.autodiff.ForwardAccumulator(primals = model.trainable_variables, 
                                            tangents = v) as acc:
            loss = loss_obj(labels, model(images, training=True))
        grad_norm += acc.jvp(loss)**2
    
    return tf.math.sqrt(grad_norm / JL_dim)
