## Open Catalyst Experiments 2024 (OCx24): Bridging Experiments and Computational Models
In this work, we seek to directly bridge the gap between computational descriptors and experimental outcomes for heterogeneous catalysis. We consider two important green chemistries: the hydrogen evolution reaction and the electrochemical reduction of carbon dioxide. To do this, we created a curated dataset of experimental results with materials synthesized and tested in a reproducible manner under industrially relevant conditions. We used this data to build models to directly predict experimental outcomes using computational features. For more information, please read the manuscript [paper](http://arxiv.org/abs/2411.11783).

### Experimental datasets
To support this work, we performed X-ray fluorescence (XRF), X-ray diffraction (XRD), and electrochemical testing. Summaries of this data is all publically available [here](https://github.com/FAIR-Chem/fairchem/tree/main/src/fairchem/applications/ocx/data/experimental_data).

### Computational datasets
|Splits |Size of uncompressed version (in bytes)    | MD5 checksum (download link)   |
|---   |---    |---    |
|Computational screening data |1.5G  | [9e75b95bb1a2ae691f07cf630eac3378](https://dl.fbaipublicfiles.com/opencatalystproject/data/ocx24/comp_df_241022.csv)   |


### Citing this work

If you use this codebase in your work, please consider citing:

```bibtex
@misc{abed2024opencatalystexperiments2024,
      title={Open Catalyst Experiments 2024 (OCx24): Bridging Experiments and Computational Models}, 
      author={Jehad Abed and Jiheon Kim and Muhammed Shuaibi and Brook Wander and Boris Duijf and Suhas Mahesh and Hyeonseok Lee and Vahe Gharakhanyan and Sjoerd Hoogland and Erdem Irtem and Janice Lan and Niels Schouten and Anagha Usha Vijayakumar and Jason Hattrick-Simpers and John R. Kitchin and Zachary W. Ulissi and Aaike van Vugt and Edward H. Sargent and David Sinton and C. Lawrence Zitnick},
      year={2024},
      eprint={2411.11783},
      archivePrefix={arXiv},
      primaryClass={cond-mat.mtrl-sci},
      url={https://arxiv.org/abs/2411.11783}, 
}
```
