## Instructions for use

The `ml_inference.py` and `ml_train.py` files were used to generate data/figures for the hybrid modeling portions of the manuscript. Each of these files expect command line arguments which specify important details about what will be modeled. Each argument has a help string, so consult the help strings where useful. There is one additional thing worth mentioning. Combining the XRD, electrochemical testing, and computational data is time consuming, so `ml_train.py` can be run in two "modes" to avoid reprocessing the data. The first mode fully processes and combines data, while the second allows a processed data file to be read in, rather than the raw data. Processed data will have fixed input parameters (i.e. you can not change the characteristics of XRD matching -- max Rwp and min q-score). The args have been categorized with comments to make it clear when each one is necessary across these two "modes".

Pre-processed data has been supplied for CO2R and HER in the [processed data folder](https://github.com/FAIR-Chem/fairchem/tree/main/src/fairchem/applications/ocx/data/processed_data) where 40 is the max Rwp and 70 is the minimum q-score. To process the data yourself, use the XRD (`XRDDataDump-YYMMDD.csv`) and electrochemical testing (`ExptDataDump_YYMMDD_clean.csv`) csvs in the [experimental data folder](https://github.com/FAIR-Chem/fairchem/tree/main/src/fairchem/applications/ocx/data/experimental_data).
