# conftest.py

import pytest


def pytest_addoption(parser):
    parser.addoption(
        "--skip-ocpapi-integration", action="store_true", default=False, help="skip ocpapi integration tests"
    )


def pytest_configure(config):
    config.addinivalue_line("markers", "ocpapi_integration: ocpapi integration test")


def pytest_collection_modifyitems(config, items):
    if config.getoption("--skip-ocpapi-integration"):
        skip_ocpapi_integration = pytest.mark.skip(reason="skipping ocpapi integration")
        for item in items:
            if "ocpapi_integration_test" in item.keywords:
                item.add_marker(skip_ocpapi_integration)
        return
