/*
 * Decompiled with CFR 0.152.
 */
package agents.michal;

import engine.core.MarioAgent;
import engine.core.MarioForwardModel;
import engine.core.MarioTimer;
import engine.helper.MarioActions;

public class Agent
implements MarioAgent {
    private boolean facing_left;
    private int leftCounter;
    private int shootCounter;
    private STATE state;
    private boolean[] action;

    @Override
    public void initialize(MarioForwardModel marioForwardModel, MarioTimer marioTimer) {
        this.action = new boolean[MarioActions.numberOfActions()];
        this.state = STATE.WALK_FORWARD;
        this.facing_left = false;
        this.leftCounter = 0;
        this.shootCounter = 0;
    }

    private int getLocation(int n, int n2, int[][] nArray) {
        int n3 = 8 + n;
        int n4 = 8 + n2;
        return nArray[n3][n4];
    }

    private boolean thereIsObstacle(int[][] nArray) {
        int[] nArray2 = new int[]{this.getLocation(1, 0, nArray), this.getLocation(2, 0, nArray), this.getLocation(2, -1, nArray)};
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] != 17 && nArray2[i] != 23 && nArray2[i] != 24) continue;
            return true;
        }
        return false;
    }

    private boolean thereIsHole(int[][] nArray) {
        for (int i = 1; i < 3; ++i) {
            for (int j = 2; j < 8; ++j) {
                if (this.getLocation(i, j, nArray) == 0) continue;
                return false;
            }
        }
        return true;
    }

    private boolean enemyInFront(int[][] nArray) {
        for (int i = 0; i > -2; --i) {
            for (int j = 1; j < 2; ++j) {
                if (this.getLocation(j, i, nArray) <= 1) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean[] getActions(MarioForwardModel marioForwardModel, MarioTimer marioTimer) {
        int[][] nArray = marioForwardModel.getMarioSceneObservation();
        int[][] nArray2 = marioForwardModel.getMarioEnemiesObservation();
        if (this.enemyInFront(nArray2)) {
            if (this.shootCounter > 0) {
                this.action[MarioActions.SPEED.getValue()] = false;
            } else {
                this.action[MarioActions.SPEED.getValue()] = true;
                ++this.shootCounter;
            }
            return this.action;
        }
        if (this.shootCounter > 0) {
            this.shootCounter = 0;
        }
        switch (this.state) {
            case WALK_BACKWARD: {
                if (this.leftCounter > 5) {
                    this.state = STATE.WALK_FORWARD;
                    this.facing_left = false;
                }
                ++this.leftCounter;
                this.action[MarioActions.LEFT.getValue()] = true;
                this.action[MarioActions.RIGHT.getValue()] = false;
                break;
            }
            case WALK_FORWARD: {
                this.action[MarioActions.LEFT.getValue()] = false;
                if (this.thereIsHole(nArray)) {
                    this.state = STATE.JUMP_HOLE;
                    this.action[MarioActions.JUMP.getValue()] = true;
                    this.action[MarioActions.SPEED.getValue()] = true;
                    break;
                }
                if (this.thereIsObstacle(nArray)) {
                    this.state = STATE.JUMP;
                    this.action[MarioActions.JUMP.getValue()] = true;
                    this.action[MarioActions.RIGHT.getValue()] = true;
                    this.action[MarioActions.SPEED.getValue()] = false;
                    break;
                }
                this.action[MarioActions.RIGHT.getValue()] = true;
                this.action[MarioActions.SPEED.getValue()] = false;
                break;
            }
            case JUMP: {
                if (this.action[MarioActions.RIGHT.getValue()] && this.thereIsHole(nArray)) {
                    this.action[MarioActions.RIGHT.getValue()] = false;
                    this.action[MarioActions.LEFT.getValue()] = true;
                    this.facing_left = true;
                    break;
                }
                if (!marioForwardModel.isMarioOnGround()) break;
                if (this.facing_left) {
                    this.state = STATE.WALK_BACKWARD;
                    this.leftCounter = 0;
                } else {
                    this.state = STATE.WALK_FORWARD;
                }
                this.action[MarioActions.LEFT.getValue()] = false;
                this.action[MarioActions.RIGHT.getValue()] = false;
                this.action[MarioActions.JUMP.getValue()] = false;
                this.action[MarioActions.SPEED.getValue()] = false;
                break;
            }
            case JUMP_HOLE: {
                if (!marioForwardModel.isMarioOnGround()) break;
                this.state = STATE.WALK_FORWARD;
                this.action[MarioActions.JUMP.getValue()] = false;
                this.action[MarioActions.SPEED.getValue()] = false;
                this.action[MarioActions.LEFT.getValue()] = false;
                this.action[MarioActions.RIGHT.getValue()] = false;
            }
        }
        return this.action;
    }

    @Override
    public String getAgentName() {
        return "MichalAgent";
    }

    private static enum STATE {
        WALK_FORWARD,
        WALK_BACKWARD,
        JUMP,
        JUMP_HOLE;

    }
}

