/*
 * Decompiled with CFR 0.152.
 */
package agents.spencerSchumann;

import agents.spencerSchumann.EnemySimulator;
import agents.spencerSchumann.MarioState;
import agents.spencerSchumann.MovementPlanner;
import agents.spencerSchumann.PlanRunner;
import agents.spencerSchumann.Scene;
import agents.spencerSchumann.Tiles;
import engine.core.MarioAgent;
import engine.core.MarioForwardModel;
import engine.core.MarioTimer;
import engine.helper.MarioActions;

public class Agent
implements MarioAgent {
    private Tiles tiles;
    private MarioState mario;
    private EnemySimulator enemySim;
    private boolean manualOverride = false;
    private PlanRunner planRunner;

    @Override
    public void initialize(MarioForwardModel marioForwardModel, MarioTimer marioTimer) {
        this.tiles = new Tiles();
        this.mario = new MarioState();
        this.planRunner = new PlanRunner();
        this.enemySim = new EnemySimulator();
    }

    @Override
    public boolean[] getActions(MarioForwardModel marioForwardModel, MarioTimer marioTimer) {
        float[] fArray = marioForwardModel.getMarioFloatPos();
        this.tiles.addObservation(marioForwardModel);
        int n = (int)(fArray[0] / 16.0f);
        int n2 = (int)(fArray[1] / 16.0f);
        marioForwardModel.getClass();
        int n3 = n - 16 / 2;
        marioForwardModel.getClass();
        int n4 = n2 - 16 / 2;
        marioForwardModel.getClass();
        marioForwardModel.getClass();
        int[][] nArray = this.tiles.getScene(n3, n4, 16, 16);
        this.mario.update(marioForwardModel);
        Scene scene = new Scene(marioForwardModel, nArray);
        this.enemySim.update(scene);
        this.enemySim.update(marioForwardModel);
        boolean[] blArray = null;
        if (this.planRunner.isDone() || this.planRunner.isLastAction() || this.manualOverride) {
            MovementPlanner movementPlanner = new MovementPlanner(scene, this.mario, this.enemySim.clone());
            PlanRunner planRunner = movementPlanner.planMovement();
            if (planRunner != null) {
                this.planRunner = planRunner;
            } else {
                blArray = new boolean[5];
                blArray[MarioActions.RIGHT.getValue()] = true;
                boolean bl = marioForwardModel.mayMarioJump() || !marioForwardModel.isMarioOnGround();
                blArray[MarioActions.JUMP.getValue()] = bl;
                blArray[MarioActions.SPEED.getValue()] = bl;
            }
        }
        if (blArray == null) {
            blArray = this.planRunner.nextAction();
        }
        return blArray;
    }

    @Override
    public String getAgentName() {
        return "SpencerShumannAgent";
    }
}

