/*
 * Decompiled with CFR 0.152.
 */
package agents.spencerSchumann;

import agents.spencerSchumann.Edge;
import agents.spencerSchumann.Enemy;
import agents.spencerSchumann.EnemySimulator;
import agents.spencerSchumann.MarioState;
import agents.spencerSchumann.MotionSimulator;
import agents.spencerSchumann.PlanRunner;
import agents.spencerSchumann.Scene;
import engine.helper.MarioActions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class MovementPlanner {
    Scene scene;
    MarioState mario;
    EnemySimulator enemySim;
    Edge targetFloor;
    public float[] projectedX;
    public float[] projectedY;

    MovementPlanner(Scene scene, MarioState marioState, EnemySimulator enemySimulator) {
        this.scene = scene;
        this.mario = marioState;
        this.enemySim = enemySimulator;
    }

    private int flightTimeForJump(int n, float f) {
        Scene scene = new Scene(0.0f, 0.0f);
        scene.floors.add(new Edge(-10.0f, f, 10.0f, f));
        MarioState marioState = new MarioState();
        marioState.mayJump = true;
        marioState.onGround = true;
        MotionSimulator motionSimulator = new MotionSimulator(scene, marioState);
        boolean[] blArray = new boolean[5];
        blArray[MarioActions.JUMP.getValue()] = true;
        for (int i = 0; i < n; ++i) {
            motionSimulator.update(blArray);
        }
        boolean[] blArray2 = new boolean[5];
        do {
            motionSimulator.update(blArray2);
            if (!motionSimulator.mario.onGround) continue;
            return motionSimulator.getTicks();
        } while (!(motionSimulator.mario.vy > 0.0f) || !(motionSimulator.mario.y > f));
        return -1;
    }

    private int ticksToPos(float f) {
        Scene scene = new Scene(0.0f, 0.0f);
        scene.floors.add(new Edge(-1000.0f, 1.0f, f, 1.0f));
        MarioState marioState = new MarioState();
        marioState.vx = this.mario.vx;
        MotionSimulator motionSimulator = new MotionSimulator(scene, marioState);
        motionSimulator.leftWorldEdge = false;
        boolean[] blArray = new boolean[5];
        blArray[MarioActions.RIGHT.getValue()] = true;
        blArray[MarioActions.SPEED.getValue()] = true;
        do {
            motionSimulator.update(blArray);
        } while (!(motionSimulator.mario.x >= f));
        return motionSimulator.getTicks();
    }

    private float posFromTicks(int n) {
        Scene scene = new Scene(0.0f, 0.0f);
        scene.floors.add(new Edge(-1000.0f, 1.0f, (float)n * 100.0f, 1.0f));
        MarioState marioState = new MarioState();
        marioState.vx = this.mario.vx;
        MotionSimulator motionSimulator = new MotionSimulator(scene, marioState);
        motionSimulator.leftWorldEdge = false;
        boolean[] blArray = new boolean[5];
        blArray[MarioActions.RIGHT.getValue()] = true;
        blArray[MarioActions.SPEED.getValue()] = true;
        for (int i = 0; i < n; ++i) {
            motionSimulator.update(blArray);
        }
        return motionSimulator.mario.x;
    }

    private boolean checkPlan(PlanRunner planRunner, Edge edge) {
        MotionSimulator motionSimulator = new MotionSimulator(this.scene, this.mario);
        this.projectedX = new float[planRunner.getLength() + 1];
        this.projectedY = new float[planRunner.getLength() + 1];
        this.targetFloor = edge;
        EnemySimulator enemySimulator = this.enemySim.clone();
        while (!planRunner.isDone()) {
            enemySimulator.update(this.scene);
            motionSimulator.update(planRunner.nextAction());
            this.projectedX[planRunner.getIndex() - 1] = motionSimulator.mario.x;
            this.projectedY[planRunner.getIndex() - 1] = motionSimulator.mario.y;
            for (Enemy enemy : enemySimulator.enemies) {
                if (!(motionSimulator.mario.x >= enemy.x - enemy.width / 2.0f - 4.0f) || !(motionSimulator.mario.x <= enemy.x + enemy.width / 2.0f + 4.0f) || !(motionSimulator.mario.y >= enemy.y - enemy.height) || !(motionSimulator.mario.y - motionSimulator.mario.height <= enemy.y)) continue;
                return false;
            }
        }
        planRunner.rewind();
        return motionSimulator.mario.x > edge.x1 - 4.0f && motionSimulator.mario.x < edge.x2 + 4.0f && motionSimulator.mario.y == edge.y1 - 1.0f;
    }

    private PlanRunner planJump(Edge edge, Edge edge2) {
        float f = edge2.y1 - edge.y1;
        float f2 = edge2.x1 - this.mario.x + 4.0f;
        if (f2 < 0.0f) {
            f2 = edge2.x2 - this.mario.x - 3.0f;
        }
        int n = this.ticksToPos(f2);
        int n2 = 0;
        for (int i = 0; i <= 7; ++i) {
            n2 = this.flightTimeForJump(i, f);
            if (n2 < 0) continue;
            PlanRunner planRunner = new PlanRunner();
            if (n <= n2) {
                planRunner.addKey(MarioActions.SPEED.getValue());
                planRunner.addKey(MarioActions.JUMP.getValue(), 0, i);
                planRunner.addKey(MarioActions.RIGHT.getValue(), n2 - n, n);
            } else {
                int n3 = n - n2 + 1;
                float f3 = this.posFromTicks(n3);
                if (f3 + this.mario.x >= edge.x2 + 4.0f) continue;
                planRunner.addKey(MarioActions.SPEED.getValue());
                planRunner.addKey(MarioActions.RIGHT.getValue(), 0, n);
                planRunner.addKey(MarioActions.JUMP.getValue(), n3, i);
            }
            if (!this.checkPlan(planRunner, edge2)) continue;
            return planRunner;
        }
        return null;
    }

    private ArrayList<Edge> findTargetFloors(Edge edge) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        Collections.sort(this.scene.floors, new BestTarget());
        for (Edge edge2 : this.scene.floors) {
            if (!(edge2.x2 > this.mario.x) || !(edge2.y1 + 64.0f >= edge.y1)) continue;
            arrayList.add(edge2);
        }
        return arrayList;
    }

    private Edge findCurrentFloor() {
        for (Edge edge : this.scene.floors) {
            if (this.mario.y != edge.y1 - 1.0f || !(this.mario.x >= edge.x1 - 4.0f) || !(this.mario.x <= edge.x2 + 4.0f)) continue;
            return edge;
        }
        return null;
    }

    public PlanRunner planMovement() {
        Edge edge = this.findCurrentFloor();
        if (edge == null) {
            return null;
        }
        ArrayList<Edge> arrayList = this.findTargetFloors(edge);
        if (!arrayList.isEmpty()) {
            for (Edge edge2 : arrayList) {
                PlanRunner planRunner;
                if (edge2 == edge || null == (planRunner = this.planJump(edge, edge2))) continue;
                return planRunner;
            }
        }
        return null;
    }

    public Edge getTargetFloor() {
        return this.targetFloor;
    }

    class BestTarget
    implements Comparator<Edge> {
        BestTarget() {
        }

        @Override
        public int compare(Edge edge, Edge edge2) {
            if (edge.x2 > edge2.x2) {
                return -1;
            }
            if (edge.x2 < edge2.x2) {
                return 1;
            }
            if (edge.y1 > edge2.y1) {
                return -1;
            }
            if (edge.y1 < edge2.y1) {
                return 1;
            }
            return 0;
        }
    }
}

