/*
 * Decompiled with CFR 0.152.
 */
package agents.trondEllingsen;

import engine.core.MarioAgent;
import engine.core.MarioForwardModel;
import engine.core.MarioTimer;
import engine.helper.MarioActions;

public class Agent
implements MarioAgent {
    private JumpType jumpType = JumpType.NONE;
    private int jumpCount = 0;
    private int jumpSize = -1;
    private float prevY = 0.0f;
    private boolean[] action;

    @Override
    public void initialize(MarioForwardModel marioForwardModel, MarioTimer marioTimer) {
        this.action = new boolean[MarioActions.numberOfActions()];
        this.action[MarioActions.RIGHT.getValue()] = true;
        this.action[MarioActions.SPEED.getValue()] = true;
    }

    private int getWallHeight(int n, int n2, int[][] nArray) {
        int n3 = n2 + 1;
        int n4 = 0;
        while (n3-- > 0 && nArray[n + 1][n3] != 0) {
            ++n4;
        }
        return n4;
    }

    private boolean dangerOfGap(int n, int n2, int[][] nArray) {
        for (int i = n2 + 1; i < nArray[0].length; ++i) {
            if (nArray[n + 1][i] == 0) continue;
            return false;
        }
        return true;
    }

    private boolean enemyInRange(MarioForwardModel marioForwardModel, Rectangle rectangle) {
        for (int i = 0; i < marioForwardModel.getEnemiesFloatPos().length; i += 3) {
            if (!rectangle.contains(marioForwardModel.getEnemiesFloatPos()[i + 1] - marioForwardModel.getMarioFloatPos()[0], marioForwardModel.getMarioFloatPos()[1] - marioForwardModel.getEnemiesFloatPos()[i + 2])) continue;
            return true;
        }
        return false;
    }

    private final void setJump(JumpType jumpType, int n) {
        this.jumpType = jumpType;
        this.jumpSize = n;
        this.jumpCount = 0;
    }

    @Override
    public boolean[] getActions(MarioForwardModel marioForwardModel, MarioTimer marioTimer) {
        int n;
        float f = marioForwardModel.getMarioFloatVelocity()[0];
        boolean bl = this.enemyInRange(marioForwardModel, new Rectangle(-13.0f, -57.0f, 105.0f, 87.0f));
        boolean bl2 = this.enemyInRange(marioForwardModel, new Rectangle(-28.0f, 28.0f, 58.0f, 45.0f));
        boolean bl3 = this.dangerOfGap(marioForwardModel.getMarioScreenTilePos()[0], marioForwardModel.getMarioScreenTilePos()[1], marioForwardModel.getScreenSceneObservation());
        if ((marioForwardModel.isMarioOnGround() || marioForwardModel.mayMarioJump()) && !this.jumpType.equals((Object)JumpType.NONE)) {
            this.setJump(JumpType.NONE, -1);
        } else if (marioForwardModel.mayMarioJump()) {
            n = this.getWallHeight(marioForwardModel.getMarioScreenTilePos()[0], marioForwardModel.getMarioScreenTilePos()[1], marioForwardModel.getScreenSceneObservation());
            if (bl3 && f > 0.0f) {
                this.setJump(JumpType.GAP, f < 6.0f ? (int)(9.0f - f) : 1);
            } else if (f <= 1.0f && !bl2 && n > 0) {
                this.setJump(JumpType.WALL, n >= 4 ? n + 3 : n);
            } else if (!(!bl || bl2 && f > 2.0f)) {
                this.setJump(JumpType.ENEMY, 7);
            }
        } else {
            ++this.jumpCount;
        }
        n = this.prevY < marioForwardModel.getMarioFloatPos()[1] && this.jumpType.equals((Object)JumpType.NONE) ? 1 : 0;
        this.action[MarioActions.LEFT.getValue()] = n != 0 && (bl && bl2 || bl3);
        this.action[MarioActions.RIGHT.getValue()] = n == 0 && (!bl2 || this.jumpType != JumpType.WALL);
        this.action[MarioActions.JUMP.getValue()] = !this.jumpType.equals((Object)JumpType.NONE) && this.jumpCount < this.jumpSize;
        this.action[MarioActions.SPEED.getValue()] = !this.jumpType.equals((Object)JumpType.ENEMY) || !this.action[MarioActions.SPEED.getValue()] || marioForwardModel.getMarioMode() != 2;
        this.prevY = marioForwardModel.getMarioFloatPos()[1];
        return this.action;
    }

    @Override
    public String getAgentName() {
        return "TrondEllingsen";
    }

    private class Rectangle {
        private float x;
        private float y;
        private float width;
        private float height;

        public Rectangle(float f, float f2, float f3, float f4) {
            this.x = f;
            this.y = f2;
            this.width = f3;
            this.height = f4;
        }

        public boolean contains(float f, float f2) {
            return f >= this.x && f2 >= this.y && f <= this.x + this.width && f2 <= this.y + this.height;
        }
    }

    private static enum JumpType {
        ENEMY,
        GAP,
        WALL,
        NONE;

    }
}

