/*
 * Decompiled with CFR 0.152.
 */
package engine.core;

import engine.graphics.MarioImage;
import engine.graphics.MarioTilemap;
import engine.helper.Assets;
import engine.helper.SpriteType;
import engine.helper.TileFeature;
import java.awt.Graphics;
import java.util.ArrayList;

public class MarioLevel {
    public int width = 256;
    public int tileWidth = 16;
    public int height = 256;
    public int tileHeight = 16;
    public int totalCoins = 0;
    public int marioTileX;
    public int marioTileY;
    public int exitTileX;
    public int exitTileY;
    private int[][] levelTiles;
    private SpriteType[][] spriteTemplates;
    private int[][] lastSpawnTime;
    private MarioTilemap graphics;
    private MarioImage flag;

    public MarioLevel(String string, boolean bl) {
        int n;
        int n2;
        int n3;
        if (string.trim().length() == 0) {
            this.tileWidth = 0;
            this.width = 0;
            this.tileHeight = 0;
            this.height = 0;
            return;
        }
        String[] stringArray = string.split("\n");
        this.tileWidth = stringArray[0].length();
        this.width = this.tileWidth * 16;
        this.tileHeight = stringArray.length;
        this.height = this.tileHeight * 16;
        this.levelTiles = new int[stringArray[0].length()][stringArray.length];
        this.spriteTemplates = new SpriteType[stringArray[0].length()][stringArray.length];
        this.lastSpawnTime = new int[stringArray[0].length()][stringArray.length];
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            for (n2 = 0; n2 < stringArray[n3].length(); ++n2) {
                this.levelTiles[n2][n3] = 0;
                this.spriteTemplates[n2][n3] = SpriteType.NONE;
                this.lastSpawnTime[n2][n3] = -40;
            }
        }
        n3 = 0;
        n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            block38: for (int i = 0; i < stringArray[n].length(); ++i) {
                Character c = Character.valueOf(stringArray[n].charAt(i));
                switch (c.charValue()) {
                    case 'M': {
                        this.marioTileX = i;
                        this.marioTileY = n;
                        n3 = 1;
                        continue block38;
                    }
                    case 'F': {
                        this.exitTileX = i;
                        this.exitTileY = n;
                        n2 = 1;
                        continue block38;
                    }
                    case 'y': {
                        this.spriteTemplates[i][n] = SpriteType.SPIKY;
                        continue block38;
                    }
                    case 'Y': {
                        this.spriteTemplates[i][n] = SpriteType.SPIKY_WINGED;
                        continue block38;
                    }
                    case 'E': 
                    case 'g': {
                        this.spriteTemplates[i][n] = SpriteType.GOOMBA;
                        continue block38;
                    }
                    case 'G': {
                        this.spriteTemplates[i][n] = SpriteType.GOOMBA_WINGED;
                        continue block38;
                    }
                    case 'k': {
                        this.spriteTemplates[i][n] = SpriteType.GREEN_KOOPA;
                        continue block38;
                    }
                    case 'K': {
                        this.spriteTemplates[i][n] = SpriteType.GREEN_KOOPA_WINGED;
                        continue block38;
                    }
                    case 'r': {
                        this.spriteTemplates[i][n] = SpriteType.RED_KOOPA;
                        continue block38;
                    }
                    case 'R': {
                        this.spriteTemplates[i][n] = SpriteType.RED_KOOPA_WINGED;
                        continue block38;
                    }
                    case 'X': {
                        this.levelTiles[i][n] = 1;
                        continue block38;
                    }
                    case '#': {
                        this.levelTiles[i][n] = 2;
                        continue block38;
                    }
                    case '%': {
                        int n4 = 0;
                        if (i > 0 && stringArray[n].charAt(i - 1) == '%') {
                            n4 += 2;
                        }
                        if (i < this.levelTiles.length - 1 && stringArray[n].charAt(i + 1) == '%') {
                            ++n4;
                        }
                        this.levelTiles[i][n] = 43 + n4;
                        continue block38;
                    }
                    case '|': {
                        this.levelTiles[i][n] = 47;
                        continue block38;
                    }
                    case '*': {
                        int n4 = 0;
                        if (n > 0 && stringArray[n - 1].charAt(i) == '*') {
                            ++n4;
                        }
                        if (n > 1 && stringArray[n - 2].charAt(i) == '*') {
                            ++n4;
                        }
                        this.levelTiles[i][n] = 3 + n4;
                        continue block38;
                    }
                    case 'B': {
                        this.levelTiles[i][n] = 3;
                        continue block38;
                    }
                    case 'b': {
                        int n4 = 0;
                        if (n > 1 && stringArray[n - 2].charAt(i) == 'B') {
                            ++n4;
                        }
                        this.levelTiles[i][n] = 4 + n4;
                        continue block38;
                    }
                    case '?': 
                    case '@': {
                        this.levelTiles[i][n] = 8;
                        continue block38;
                    }
                    case '!': 
                    case 'Q': {
                        ++this.totalCoins;
                        this.levelTiles[i][n] = 11;
                        continue block38;
                    }
                    case '1': {
                        this.levelTiles[i][n] = 48;
                        continue block38;
                    }
                    case '2': {
                        ++this.totalCoins;
                        this.levelTiles[i][n] = 49;
                        continue block38;
                    }
                    case 'D': {
                        this.levelTiles[i][n] = 14;
                        continue block38;
                    }
                    case 'S': {
                        this.levelTiles[i][n] = 6;
                        continue block38;
                    }
                    case 'C': {
                        ++this.totalCoins;
                        this.levelTiles[i][n] = 7;
                        continue block38;
                    }
                    case 'U': {
                        this.levelTiles[i][n] = 50;
                        continue block38;
                    }
                    case 'L': {
                        this.levelTiles[i][n] = 51;
                        continue block38;
                    }
                    case 'o': {
                        ++this.totalCoins;
                        this.levelTiles[i][n] = 15;
                        continue block38;
                    }
                    case 't': {
                        int n4 = 0;
                        boolean bl2 = false;
                        if (i < stringArray[n].length() - 1 && Character.toLowerCase(stringArray[n].charAt(i + 1)) != 't' && i > 0 && Character.toLowerCase(stringArray[n].charAt(i - 1)) != 't') {
                            bl2 = true;
                        }
                        if (i > 0 && (this.levelTiles[i - 1][n] == 18 || this.levelTiles[i - 1][n] == 20)) {
                            ++n4;
                        }
                        if (n > 0 && Character.toLowerCase(stringArray[n - 1].charAt(i)) == 't') {
                            n4 = bl2 ? ++n4 : (n4 += 2);
                        }
                        if (bl2) {
                            this.levelTiles[i][n] = 52 + n4;
                            continue block38;
                        }
                        this.levelTiles[i][n] = 18 + n4;
                        continue block38;
                    }
                    case 'T': {
                        boolean bl2;
                        int n4 = 0;
                        boolean bl3 = bl2 = i < stringArray[n].length() - 1 && Character.toLowerCase(stringArray[n].charAt(i + 1)) != 't' && i > 0 && Character.toLowerCase(stringArray[n].charAt(i - 1)) != 't';
                        if (i > 0 && (this.levelTiles[i - 1][n] == 18 || this.levelTiles[i - 1][n] == 20)) {
                            ++n4;
                        }
                        if (n > 0 && Character.toLowerCase(stringArray[n - 1].charAt(i)) == 't') {
                            n4 = bl2 ? ++n4 : (n4 += 2);
                        }
                        if (bl2) {
                            this.levelTiles[i][n] = 52 + n4;
                            continue block38;
                        }
                        if (n4 == 0) {
                            this.spriteTemplates[i][n] = SpriteType.ENEMY_FLOWER;
                        }
                        this.levelTiles[i][n] = 18 + n4;
                        continue block38;
                    }
                    case '<': {
                        this.levelTiles[i][n] = 18;
                        continue block38;
                    }
                    case '>': {
                        this.levelTiles[i][n] = 19;
                        continue block38;
                    }
                    case '[': {
                        this.levelTiles[i][n] = 20;
                        continue block38;
                    }
                    case ']': {
                        this.levelTiles[i][n] = 21;
                    }
                }
            }
        }
        if (n3 == 0) {
            this.marioTileX = 0;
            this.marioTileY = this.findFirstFloor(stringArray, this.marioTileX);
        }
        if (n2 == 0) {
            this.exitTileX = stringArray[0].length() - 1;
            this.exitTileY = this.findFirstFloor(stringArray, this.exitTileX);
        }
        for (n = this.exitTileY; n > Math.max(1, this.exitTileY - 11); --n) {
            this.levelTiles[this.exitTileX][n] = 40;
        }
        this.levelTiles[this.exitTileX][Math.max((int)1, (int)(this.exitTileY - 11))] = 39;
        if (bl) {
            this.graphics = new MarioTilemap(Assets.level, this.levelTiles);
            this.flag = new MarioImage(Assets.level, 41);
            this.flag.width = 16;
            this.flag.height = 16;
        }
    }

    public MarioLevel clone() {
        MarioLevel marioLevel = new MarioLevel("", false);
        marioLevel.width = this.width;
        marioLevel.height = this.height;
        marioLevel.tileWidth = this.tileWidth;
        marioLevel.tileHeight = this.tileHeight;
        marioLevel.totalCoins = this.totalCoins;
        marioLevel.marioTileX = this.marioTileX;
        marioLevel.marioTileY = this.marioTileY;
        marioLevel.exitTileX = this.exitTileX;
        marioLevel.exitTileY = this.exitTileY;
        marioLevel.levelTiles = new int[this.levelTiles.length][this.levelTiles[0].length];
        marioLevel.lastSpawnTime = new int[this.levelTiles.length][this.levelTiles[0].length];
        for (int i = 0; i < marioLevel.levelTiles.length; ++i) {
            for (int j = 0; j < marioLevel.levelTiles[i].length; ++j) {
                marioLevel.levelTiles[i][j] = this.levelTiles[i][j];
                marioLevel.lastSpawnTime[i][j] = this.lastSpawnTime[i][j];
            }
        }
        marioLevel.spriteTemplates = this.spriteTemplates;
        return marioLevel;
    }

    public boolean isBlocking(int n, int n2, float f, float f2) {
        int n3 = this.getBlock(n, n2);
        ArrayList<TileFeature> arrayList = TileFeature.getTileType(n3);
        boolean bl = arrayList.contains((Object)TileFeature.BLOCK_ALL);
        bl |= f2 < 0.0f && arrayList.contains((Object)TileFeature.BLOCK_UPPER);
        return bl |= f2 > 0.0f && arrayList.contains((Object)TileFeature.BLOCK_LOWER);
    }

    public int getBlock(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n > this.tileWidth - 1) {
            n = this.tileWidth - 1;
        }
        if (n2 < 0 || n2 > this.tileHeight - 1) {
            return 0;
        }
        return this.levelTiles[n][n2];
    }

    public void setBlock(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n > this.tileWidth - 1 || n2 > this.tileHeight - 1) {
            return;
        }
        this.levelTiles[n][n2] = n3;
    }

    public void setShiftIndex(int n, int n2, int n3) {
        if (this.graphics == null || n < 0 || n2 < 0 || n > this.tileWidth - 1 || n2 > this.tileHeight - 1) {
            return;
        }
        this.graphics.moveShift[n][n2] = n3;
    }

    public SpriteType getSpriteType(int n, int n2) {
        if (n < 0 || n2 < 0 || n > this.tileWidth - 1 || n2 > this.tileHeight - 1) {
            return SpriteType.NONE;
        }
        return this.spriteTemplates[n][n2];
    }

    public int getLastSpawnTick(int n, int n2) {
        if (n < 0 || n2 < 0 || n > this.tileWidth - 1 || n2 > this.tileHeight - 1) {
            return 0;
        }
        return this.lastSpawnTime[n][n2];
    }

    public void setLastSpawnTick(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n > this.tileWidth - 1 || n2 > this.tileHeight - 1) {
            return;
        }
        this.lastSpawnTime[n][n2] = n3;
    }

    public String getSpriteCode(int n, int n2) {
        return n + "_" + n2 + "_" + this.getSpriteType(n, n2).getValue();
    }

    private boolean isSolid(char c) {
        return c == 'X' || c == '#' || c == '@' || c == '!' || c == 'B' || c == 'C' || c == 'Q' || c == '<' || c == '>' || c == '[' || c == ']' || c == '?' || c == 'S' || c == 'U' || c == 'D' || c == '%' || c == 't' || c == 'T';
    }

    private int findFirstFloor(String[] stringArray, int n) {
        boolean bl = true;
        for (int i = stringArray.length - 1; i >= 0; --i) {
            Character c = Character.valueOf(stringArray[i].charAt(n));
            if (this.isSolid(c.charValue())) {
                bl = false;
                continue;
            }
            if (bl || this.isSolid(c.charValue())) continue;
            return i;
        }
        return -1;
    }

    public void update(int n, int n2) {
    }

    public void render(Graphics graphics, int n, int n2) {
        this.graphics.render(graphics, n, n2);
        if (n + 256 >= this.exitTileX * 16) {
            this.flag.render(graphics, this.exitTileX * 16 - 8 - n, Math.max(1, this.exitTileY - 11) * 16 + 16 - n2);
        }
    }
}

