/*
 * Decompiled with CFR 0.152.
 */
package engine.core;

import engine.core.MarioAgent;
import engine.core.MarioGame;
import engine.core.MarioResult;

public class MarioLevelModel {
    public static final char MARIO_START = 'M';
    public static final char MARIO_EXIT = 'F';
    public static final char EMPTY = '-';
    public static final char GROUND = 'X';
    public static final char PYRAMID_BLOCK = '#';
    public static final char NORMAL_BRICK = 'S';
    public static final char COIN_BRICK = 'C';
    public static final char LIFE_BRICK = 'L';
    public static final char SPECIAL_BRICK = 'U';
    public static final char SPECIAL_QUESTION_BLOCK = '@';
    public static final char COIN_QUESTION_BLOCK = '!';
    public static final char COIN_HIDDEN_BLOCK = '2';
    public static final char LIFE_HIDDEN_BLOCK = '1';
    public static final char USED_BLOCK = 'D';
    public static final char COIN = 'o';
    public static final char PIPE = 't';
    public static final char PIPE_FLOWER = 'T';
    public static final char BULLET_BILL = '*';
    public static final char PLATFORM_BACKGROUND = '|';
    public static final char PLATFORM = '%';
    public static final char GOOMBA = 'g';
    public static final char GOOMBA_WINGED = 'G';
    public static final char RED_KOOPA = 'r';
    public static final char RED_KOOPA_WINGED = 'R';
    public static final char GREEN_KOOPA = 'k';
    public static final char GREEN_KOOPA_WINGED = 'K';
    public static final char SPIKY = 'y';
    public static final char SPIKY_WINGED = 'Y';
    private char[][] map;

    public static char[] getEnemyTiles() {
        return new char[]{'*', 'T'};
    }

    public static char[] getBumpableTiles() {
        return new char[]{'S', 'C', 'L', 'U', '@', '!'};
    }

    public static char[] getBlockTiles() {
        return new char[]{'X', '#', 'D', 'S', 'C', 'L', 'U', '@', '!', 't', 'T', '*'};
    }

    public static char[] getBlockNonSpecialTiles() {
        return new char[]{'X', '#', 'D', 't'};
    }

    public static char[] getNonBlockingTiles() {
        return new char[]{'o', '2', '1', '|'};
    }

    public static char[] getCollectablesTiles() {
        return new char[]{'o', 'C', 'L', 'U', '@', '!', '2', '1'};
    }

    public static char getWingedEnemyVersion(char c, boolean bl) {
        if (!bl) {
            if (c == 'G') {
                return 'g';
            }
            if (c == 'K') {
                return 'k';
            }
            if (c == 'R') {
                return 'r';
            }
            if (c == 'Y') {
                return 'y';
            }
            return c;
        }
        if (c == 'g') {
            return 'G';
        }
        if (c == 'k') {
            return 'K';
        }
        if (c == 'r') {
            return 'R';
        }
        if (c == 'y') {
            return 'Y';
        }
        return c;
    }

    public static char[] getEnemyCharacters() {
        return new char[]{'g', 'G', 'r', 'R', 'k', 'K', 'y', 'Y'};
    }

    public static char[] getEnemyCharacters(boolean bl) {
        if (bl) {
            return new char[]{'G', 'R', 'K', 'Y'};
        }
        return new char[]{'g', 'r', 'k', 'y'};
    }

    public MarioLevelModel(int n, int n2) {
        this.map = new char[n][n2];
    }

    public MarioLevelModel clone() {
        MarioLevelModel marioLevelModel = new MarioLevelModel(this.getWidth(), this.getHeight());
        for (int i = 0; i < marioLevelModel.getWidth(); ++i) {
            for (int j = 0; j < marioLevelModel.getHeight(); ++j) {
                marioLevelModel.map[i][j] = this.map[i][j];
            }
        }
        return marioLevelModel;
    }

    public int getWidth() {
        return this.map.length;
    }

    public int getHeight() {
        return this.map[0].length;
    }

    public char getBlock(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n < 0) {
            n3 = 0;
        }
        if (n2 < 0) {
            n4 = 0;
        }
        if (n > this.map.length - 1) {
            n3 = this.map.length - 1;
        }
        if (n2 > this.map[0].length - 1) {
            n4 = this.map[0].length - 1;
        }
        return this.map[n3][n4];
    }

    public void setBlock(int n, int n2, char c) {
        if (n < 0 || n2 < 0 || n > this.map.length - 1 || n2 > this.map[0].length - 1) {
            return;
        }
        this.map[n][n2] = c;
    }

    public void setRectangle(int n, int n2, int n3, int n4, char c) {
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                this.setBlock(n + i, n2 + j, c);
            }
        }
    }

    public void copyFromString(String string) {
        this.copyFromString(0, 0, 0, 0, this.getWidth(), this.getHeight(), string);
    }

    public void copyFromString(int n, int n2, int n3, int n4, int n5, int n6, String string) {
        String[] stringArray = string.split("\n");
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < n5; ++j) {
                int n7 = stringArray[0].length();
                int n8 = stringArray.length;
                this.setBlock(j + n, i + n2, stringArray[Math.min(i + n4, n8 - 1)].charAt(Math.min(j + n3, n7 - 1)));
            }
        }
    }

    public void clearMap() {
        this.setRectangle(0, 0, this.getWidth(), this.getHeight(), '-');
    }

    public String getMap() {
        String string = "";
        for (int i = 0; i < this.map[0].length; ++i) {
            for (int j = 0; j < this.map.length; ++j) {
                string = string + this.map[j][i];
            }
            string = string + "\n";
        }
        return string;
    }

    public MarioResult testALevelWithAgent(MarioAgent marioAgent, int n) {
        MarioGame marioGame = new MarioGame();
        return marioGame.runGame(marioAgent, this.getMap(), n);
    }
}

