/*
 * Decompiled with CFR 0.152.
 */
package engine.core;

import engine.core.MarioEffect;
import engine.core.MarioEvent;
import engine.core.MarioForwardModel;
import engine.core.MarioLevel;
import engine.core.MarioSprite;
import engine.effects.BrickEffect;
import engine.effects.CoinEffect;
import engine.effects.FireballEffect;
import engine.graphics.MarioBackground;
import engine.helper.EventType;
import engine.helper.GameStatus;
import engine.helper.SpriteType;
import engine.helper.TileFeature;
import engine.sprites.BulletBill;
import engine.sprites.Enemy;
import engine.sprites.FireFlower;
import engine.sprites.Fireball;
import engine.sprites.FlowerEnemy;
import engine.sprites.LifeMushroom;
import engine.sprites.Mario;
import engine.sprites.Mushroom;
import engine.sprites.Shell;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.util.ArrayList;

public class MarioWorld {
    public GameStatus gameStatus;
    public int pauseTimer = 0;
    public int fireballsOnScreen = 0;
    public int currentTimer = -1;
    public float cameraX;
    public float cameraY;
    public Mario mario;
    public MarioLevel level;
    public boolean visuals;
    public int currentTick;
    public int coins;
    public int lives;
    public ArrayList<MarioEvent> lastFrameEvents;
    private MarioEvent[] killEvents;
    private ArrayList<MarioSprite> sprites;
    private ArrayList<Shell> shellsToCheck;
    private ArrayList<Fireball> fireballsToCheck;
    private ArrayList<MarioSprite> addedSprites;
    private ArrayList<MarioSprite> removedSprites;
    private ArrayList<MarioEffect> effects;
    private MarioBackground[] backgrounds = new MarioBackground[2];

    public MarioWorld(MarioEvent[] marioEventArray) {
        this.gameStatus = GameStatus.RUNNING;
        this.sprites = new ArrayList();
        this.shellsToCheck = new ArrayList();
        this.fireballsToCheck = new ArrayList();
        this.addedSprites = new ArrayList();
        this.removedSprites = new ArrayList();
        this.effects = new ArrayList();
        this.lastFrameEvents = new ArrayList();
        this.killEvents = marioEventArray;
    }

    public void initializeVisuals(GraphicsConfiguration graphicsConfiguration) {
        int[][] nArrayArray = new int[][]{{42}, {42}, {42}, {42}, {42}, {42}, {42}, {42}, {42}, {42}, {42}, {42}, {42}, {42}, {42}, {42}};
        this.backgrounds[0] = new MarioBackground(graphicsConfiguration, 256, nArrayArray);
        nArrayArray = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {31, 32, 33, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {34, 35, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 31, 32, 33, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 34, 35, 36, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        this.backgrounds[1] = new MarioBackground(graphicsConfiguration, 256, nArrayArray);
    }

    public void initializeLevel(String string, int n) {
        this.currentTimer = n;
        this.level = new MarioLevel(string, this.visuals);
        this.mario = new Mario(this.visuals, (float)(this.level.marioTileX * 16), this.level.marioTileY * 16);
        this.mario.alive = true;
        this.mario.world = this;
        this.sprites.add(this.mario);
    }

    public ArrayList<MarioSprite> getEnemies() {
        ArrayList<MarioSprite> arrayList = new ArrayList<MarioSprite>();
        for (MarioSprite marioSprite : this.sprites) {
            if (!this.isEnemy(marioSprite)) continue;
            arrayList.add(marioSprite);
        }
        return arrayList;
    }

    public MarioWorld clone() {
        MarioWorld marioWorld = new MarioWorld(this.killEvents);
        marioWorld.visuals = false;
        marioWorld.cameraX = this.cameraX;
        marioWorld.cameraY = this.cameraY;
        marioWorld.fireballsOnScreen = this.fireballsOnScreen;
        marioWorld.gameStatus = this.gameStatus;
        marioWorld.pauseTimer = this.pauseTimer;
        marioWorld.currentTimer = this.currentTimer;
        marioWorld.currentTick = this.currentTick;
        marioWorld.level = this.level.clone();
        for (MarioSprite marioSprite : this.sprites) {
            MarioSprite marioSprite2 = marioSprite.clone();
            marioSprite2.world = marioWorld;
            if (marioSprite2.type == SpriteType.MARIO) {
                marioWorld.mario = (Mario)marioSprite2;
            }
            marioWorld.sprites.add(marioSprite2);
        }
        if (marioWorld.mario == null) {
            marioWorld.mario = (Mario)this.mario.clone();
        }
        marioWorld.coins = this.coins;
        marioWorld.lives = this.lives;
        return marioWorld;
    }

    public void addEvent(EventType eventType, int n) {
        int n2 = 0;
        if (this.mario.isLarge) {
            n2 = 1;
        }
        if (this.mario.isFire) {
            n2 = 2;
        }
        this.lastFrameEvents.add(new MarioEvent(eventType, n, this.mario.x, this.mario.y, n2, this.currentTick));
    }

    public void addEffect(MarioEffect marioEffect) {
        this.effects.add(marioEffect);
    }

    public void addSprite(MarioSprite marioSprite) {
        this.addedSprites.add(marioSprite);
        marioSprite.alive = true;
        marioSprite.world = this;
        marioSprite.added();
        marioSprite.update();
    }

    public void removeSprite(MarioSprite marioSprite) {
        this.removedSprites.add(marioSprite);
        marioSprite.alive = false;
        marioSprite.removed();
        marioSprite.world = null;
    }

    public void checkShellCollide(Shell shell) {
        this.shellsToCheck.add(shell);
    }

    public void checkFireballCollide(Fireball fireball) {
        this.fireballsToCheck.add(fireball);
    }

    public void win() {
        this.addEvent(EventType.WIN, 0);
        this.gameStatus = GameStatus.WIN;
    }

    public void lose() {
        this.addEvent(EventType.LOSE, 0);
        this.gameStatus = GameStatus.LOSE;
        this.mario.alive = false;
    }

    public void timeout() {
        this.gameStatus = GameStatus.TIME_OUT;
        this.mario.alive = false;
    }

    public int[][] getSceneObservation(float f, float f2, int n) {
        int[][] nArray = new int[16][16];
        int n2 = (int)f / 16;
        int n3 = (int)f2 / 16;
        int n4 = n3 - 8;
        int n5 = 0;
        while (n4 < n3 + 8) {
            int n6 = n2 - 8;
            int n7 = 0;
            while (n6 < n2 + 8) {
                int n8;
                int n9 = n6;
                if (n9 < 0) {
                    n9 = 0;
                }
                if (n9 > this.level.tileWidth - 1) {
                    n9 = this.level.tileWidth - 1;
                }
                if ((n8 = n4) < 0) {
                    n8 = 0;
                }
                if (n8 > this.level.tileHeight - 1) {
                    n8 = this.level.tileHeight - 1;
                }
                nArray[n7][n5] = MarioForwardModel.getBlockValueGeneralization(this.level.getBlock(n9, n8), n);
                ++n6;
                ++n7;
            }
            ++n4;
            ++n5;
        }
        return nArray;
    }

    public int[][] getEnemiesObservation(float f, float f2, int n) {
        int[][] nArray = new int[16][16];
        int n2 = (int)f / 16;
        int n3 = (int)f2 / 16;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[0].length; ++j) {
                nArray[i][j] = 0;
            }
        }
        for (MarioSprite marioSprite : this.sprites) {
            if (marioSprite.type == SpriteType.MARIO || marioSprite.getMapX() < 0 || marioSprite.getMapX() <= n2 - 8 || marioSprite.getMapX() >= n2 + 8 || marioSprite.getMapY() < 0 || marioSprite.getMapY() <= n3 - 8 || marioSprite.getMapY() >= n3 + 8) continue;
            int n4 = marioSprite.getMapX() - n2 + 8;
            int n5 = marioSprite.getMapY() - n3 + 8;
            nArray[n4][n5] = MarioForwardModel.getSpriteTypeGeneralization(marioSprite.type, n);
        }
        return nArray;
    }

    public int[][] getMergedObservation(float f, float f2, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int[][] nArray = new int[16][16];
        int n6 = (int)f / 16;
        int n7 = (int)f2 / 16;
        int n8 = n7 - 8;
        int n9 = 0;
        while (n8 < n7 + 8) {
            n5 = n6 - 8;
            n4 = 0;
            while (n5 < n6 + 8) {
                int n10;
                n3 = n5;
                if (n3 < 0) {
                    n3 = 0;
                }
                if (n3 > this.level.tileWidth - 1) {
                    n3 = this.level.tileWidth - 1;
                }
                if ((n10 = n8) < 0) {
                    n10 = 0;
                }
                if (n10 > this.level.tileHeight - 1) {
                    n10 = this.level.tileHeight - 1;
                }
                nArray[n4][n9] = MarioForwardModel.getBlockValueGeneralization(this.level.getBlock(n5, n8), n);
                ++n5;
                ++n4;
            }
            ++n8;
            ++n9;
        }
        for (MarioSprite marioSprite : this.sprites) {
            if (marioSprite.type == SpriteType.MARIO || marioSprite.getMapX() < 0 || marioSprite.getMapX() <= n6 - 8 || marioSprite.getMapX() >= n6 + 8 || marioSprite.getMapY() < 0 || marioSprite.getMapY() <= n7 - 8 || marioSprite.getMapY() >= n7 + 8) continue;
            n5 = marioSprite.getMapX() - n6 + 8;
            n4 = marioSprite.getMapY() - n7 + 8;
            n3 = MarioForwardModel.getSpriteTypeGeneralization(marioSprite.type, n2);
            if (n3 == SpriteType.NONE.getValue()) continue;
            nArray[n5][n4] = n3;
        }
        return nArray;
    }

    private boolean isEnemy(MarioSprite marioSprite) {
        return marioSprite instanceof Enemy || marioSprite instanceof FlowerEnemy || marioSprite instanceof BulletBill;
    }

    public void update(boolean[] blArray) {
        if (this.gameStatus != GameStatus.RUNNING) {
            return;
        }
        if (this.pauseTimer > 0) {
            --this.pauseTimer;
            if (this.visuals) {
                this.mario.updateGraphics();
            }
            return;
        }
        if (this.currentTimer > 0) {
            this.currentTimer -= 30;
            if (this.currentTimer <= 0) {
                this.currentTimer = 0;
                this.timeout();
                return;
            }
        }
        ++this.currentTick;
        this.cameraX = this.mario.x - 128.0f;
        if (this.cameraX + 256.0f > (float)this.level.width) {
            this.cameraX = this.level.width - 256;
        }
        if (this.cameraX < 0.0f) {
            this.cameraX = 0.0f;
        }
        this.cameraY = this.mario.y - 128.0f;
        if (this.cameraY + 256.0f > (float)this.level.height) {
            this.cameraY = this.level.height - 256;
        }
        if (this.cameraY < 0.0f) {
            this.cameraY = 0.0f;
        }
        this.lastFrameEvents.clear();
        this.fireballsOnScreen = 0;
        for (MarioSprite marioSprite : this.sprites) {
            if (marioSprite.x < this.cameraX - 64.0f || marioSprite.x > this.cameraX + 256.0f + 64.0f || marioSprite.y > (float)(this.level.height + 32)) {
                if (marioSprite.type == SpriteType.MARIO) {
                    this.lose();
                }
                this.removeSprite(marioSprite);
                if (!this.isEnemy(marioSprite) || !(marioSprite.y > 288.0f)) continue;
                this.addEvent(EventType.FALL_KILL, marioSprite.type.getValue());
                continue;
            }
            if (marioSprite.type != SpriteType.FIREBALL) continue;
            ++this.fireballsOnScreen;
        }
        this.level.update((int)this.cameraX, (int)this.cameraY);
        for (int i = (int)this.cameraX / 16 - 1; i <= (int)(this.cameraX + 256.0f) / 16 + 1; ++i) {
            for (int j = (int)this.cameraY / 16 - 1; j <= (int)(this.cameraY + 256.0f) / 16 + 1; ++j) {
                Object object;
                SpriteType object2;
                int n = 0;
                if ((float)(i * 16 + 8) > this.mario.x + 16.0f) {
                    n = -1;
                }
                if ((float)(i * 16 + 8) < this.mario.x - 16.0f) {
                    n = 1;
                }
                if ((object2 = this.level.getSpriteType(i, j)) != SpriteType.NONE) {
                    object = this.level.getSpriteCode(i, j);
                    boolean bl = false;
                    for (MarioSprite marioSprite : this.sprites) {
                        if (!marioSprite.initialCode.equals(object)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl && this.level.getLastSpawnTick(i, j) != this.currentTick - 1) {
                        MarioSprite marioSprite = object2.spawnSprite(this.visuals, i, j, n);
                        marioSprite.initialCode = object;
                        this.addSprite(marioSprite);
                    }
                    this.level.setLastSpawnTick(i, j, this.currentTick);
                }
                if (n == 0 || !((ArrayList)(object = TileFeature.getTileType(this.level.getBlock(i, j)))).contains((Object)TileFeature.SPAWNER) || this.currentTick % 100 != 0) continue;
                this.addSprite(new BulletBill(this.visuals, i * 16 + 8 + n * 8, j * 16 + 15, n));
            }
        }
        this.mario.actions = blArray;
        for (MarioSprite marioSprite : this.sprites) {
            if (!marioSprite.alive) continue;
            marioSprite.update();
        }
        for (MarioSprite marioSprite : this.sprites) {
            if (!marioSprite.alive) continue;
            marioSprite.collideCheck();
        }
        for (Shell shell : this.shellsToCheck) {
            for (MarioSprite marioSprite : this.sprites) {
                if (marioSprite == shell || !shell.alive || !marioSprite.alive || !marioSprite.shellCollideCheck(shell)) continue;
                this.removeSprite(marioSprite);
            }
        }
        this.shellsToCheck.clear();
        for (Fireball fireball : this.fireballsToCheck) {
            for (MarioSprite marioSprite : this.sprites) {
                if (marioSprite == fireball || !fireball.alive || !marioSprite.alive || !marioSprite.fireballCollideCheck(fireball)) continue;
                if (this.visuals) {
                    this.addEffect(new FireballEffect(fireball.x, fireball.y));
                }
                this.removeSprite(fireball);
            }
        }
        this.fireballsToCheck.clear();
        this.sprites.addAll(0, this.addedSprites);
        this.sprites.removeAll(this.removedSprites);
        this.addedSprites.clear();
        this.removedSprites.clear();
        if (this.killEvents != null) {
            for (MarioEvent marioEvent : this.killEvents) {
                if (!this.lastFrameEvents.contains(marioEvent)) continue;
                this.lose();
            }
        }
    }

    public void bump(int n, int n2, boolean bl) {
        int n3 = this.level.getBlock(n, n2);
        ArrayList<TileFeature> arrayList = TileFeature.getTileType(n3);
        if (arrayList.contains((Object)TileFeature.BUMPABLE)) {
            this.bumpInto(n, n2 - 1);
            this.addEvent(EventType.BUMP, 24);
            this.level.setBlock(n, n2, 14);
            this.level.setShiftIndex(n, n2, 4);
            if (arrayList.contains((Object)TileFeature.SPECIAL)) {
                if (!this.mario.isLarge) {
                    this.addSprite(new Mushroom(this.visuals, (float)(n * 16 + 9), n2 * 16 + 8));
                } else {
                    this.addSprite(new FireFlower(this.visuals, (float)(n * 16 + 9), n2 * 16 + 8));
                }
            } else if (arrayList.contains((Object)TileFeature.LIFE)) {
                this.addSprite(new LifeMushroom(this.visuals, (float)(n * 16 + 9), n2 * 16 + 8));
            } else {
                this.mario.collectCoin();
                if (this.visuals) {
                    this.addEffect(new CoinEffect(n * 16 + 8, n2 * 16));
                }
            }
        }
        if (arrayList.contains((Object)TileFeature.BREAKABLE)) {
            this.bumpInto(n, n2 - 1);
            if (bl) {
                this.addEvent(EventType.BUMP, 22);
                this.level.setBlock(n, n2, 0);
                if (this.visuals) {
                    for (int i = 0; i < 2; ++i) {
                        for (int j = 0; j < 2; ++j) {
                            this.addEffect(new BrickEffect(n * 16 + i * 8 + 4, n2 * 16 + j * 8 + 4, (i * 2 - 1) * 4, (j * 2 - 1) * 4 - 8));
                        }
                    }
                }
            } else {
                this.level.setShiftIndex(n, n2, 4);
            }
        }
    }

    public void bumpInto(int n, int n2) {
        int n3 = this.level.getBlock(n, n2);
        if (TileFeature.getTileType(n3).contains((Object)TileFeature.PICKABLE)) {
            this.addEvent(EventType.COLLECT, n3);
            this.mario.collectCoin();
            this.level.setBlock(n, n2, 0);
            if (this.visuals) {
                this.addEffect(new CoinEffect(n * 16 + 8, n2 * 16 + 8));
            }
        }
        for (MarioSprite marioSprite : this.sprites) {
            marioSprite.bumpCheck(n, n2);
        }
    }

    public void render(Graphics graphics) {
        for (int i = 0; i < this.backgrounds.length; ++i) {
            this.backgrounds[i].render(graphics, (int)this.cameraX, (int)this.cameraY);
        }
        for (MarioSprite marioSprite : this.sprites) {
            if (marioSprite.type != SpriteType.MUSHROOM && marioSprite.type != SpriteType.LIFE_MUSHROOM && marioSprite.type != SpriteType.FIRE_FLOWER && marioSprite.type != SpriteType.ENEMY_FLOWER) continue;
            marioSprite.render(graphics);
        }
        this.level.render(graphics, (int)this.cameraX, (int)this.cameraY);
        for (MarioSprite marioSprite : this.sprites) {
            if (marioSprite.type == SpriteType.MUSHROOM || marioSprite.type == SpriteType.LIFE_MUSHROOM || marioSprite.type == SpriteType.FIRE_FLOWER || marioSprite.type == SpriteType.ENEMY_FLOWER) continue;
            marioSprite.render(graphics);
        }
        for (int i = 0; i < this.effects.size(); ++i) {
            if (this.effects.get((int)i).life <= 0) {
                this.effects.remove(i);
                --i;
                continue;
            }
            this.effects.get(i).render(graphics, this.cameraX, this.cameraY);
        }
    }
}

