/*
 * Decompiled with CFR 0.152.
 */
package engine.sprites;

import engine.core.MarioSprite;
import engine.effects.DeathEffect;
import engine.graphics.MarioImage;
import engine.helper.Assets;
import engine.helper.EventType;
import engine.helper.SpriteType;
import engine.sprites.Fireball;
import engine.sprites.Shell;
import java.awt.Graphics;

public class BulletBill
extends MarioSprite {
    private MarioImage graphics;

    public BulletBill(boolean bl, float f, float f2, int n) {
        super(f, f2, SpriteType.BULLET_BILL);
        this.width = 4;
        this.height = 12;
        this.ya = -5.0f;
        this.facing = n;
        if (bl) {
            this.graphics = new MarioImage(Assets.enemies, 40);
            this.graphics.originX = 8;
            this.graphics.originY = 31;
            this.graphics.width = 16;
        }
    }

    @Override
    public MarioSprite clone() {
        BulletBill bulletBill = new BulletBill(false, this.x, this.y, this.facing);
        bulletBill.xa = this.xa;
        bulletBill.ya = this.ya;
        bulletBill.width = this.width;
        bulletBill.height = this.height;
        return bulletBill;
    }

    @Override
    public void update() {
        if (!this.alive) {
            return;
        }
        super.update();
        float f = 4.0f;
        this.xa = (float)this.facing * f;
        this.move(this.xa, 0.0f);
        if (this.graphics != null) {
            this.graphics.flipX = this.facing == -1;
        }
    }

    @Override
    public void render(Graphics graphics) {
        super.render(graphics);
        this.graphics.render(graphics, (int)(this.x - this.world.cameraX), (int)(this.y - this.world.cameraY));
    }

    @Override
    public void collideCheck() {
        if (!this.alive) {
            return;
        }
        float f = this.world.mario.x - this.x;
        float f2 = this.world.mario.y - this.y;
        if (f > -16.0f && f < 16.0f && f2 > (float)(-this.height) && f2 < (float)this.world.mario.height) {
            if (this.world.mario.ya > 0.0f && f2 <= 0.0f && (!this.world.mario.onGround || !this.world.mario.wasOnGround)) {
                this.world.mario.stomp(this);
                if (this.graphics != null) {
                    this.world.addEffect(new DeathEffect(this.x, this.y - 7.0f, this.graphics.flipX, 43, 0.0f));
                }
                this.world.removeSprite(this);
            } else {
                this.world.addEvent(EventType.HURT, this.type.getValue());
                this.world.mario.getHurt();
            }
        }
    }

    private boolean move(float f, float f2) {
        this.x += f;
        return true;
    }

    @Override
    public boolean fireballCollideCheck(Fireball fireball) {
        if (!this.alive) {
            return false;
        }
        float f = fireball.x - this.x;
        float f2 = fireball.y - this.y;
        if (f > -16.0f && f < 16.0f) {
            return f2 > (float)(-this.height) && f2 < (float)fireball.height;
        }
        return false;
    }

    @Override
    public boolean shellCollideCheck(Shell shell) {
        if (!this.alive) {
            return false;
        }
        float f = shell.x - this.x;
        float f2 = shell.y - this.y;
        if (f > -16.0f && f < 16.0f && f2 > (float)(-this.height) && f2 < (float)shell.height) {
            if (this.graphics != null) {
                this.world.addEffect(new DeathEffect(this.x, this.y - 7.0f, this.graphics.flipX, 43, -1.0f));
            }
            this.world.addEvent(EventType.SHELL_KILL, this.type.getValue());
            this.world.removeSprite(this);
            return true;
        }
        return false;
    }
}

