/*
 * Decompiled with CFR 0.152.
 */
package levelGenerators.benWeber;

import engine.core.MarioLevelGenerator;
import engine.core.MarioLevelModel;
import engine.core.MarioTimer;
import java.util.ArrayList;
import java.util.Random;

public class LevelGenerator
implements MarioLevelGenerator {
    private int maxGaps;
    private int maxTurtles;
    private int maxCoinBlocks;
    private double CHANCE_BLOCK_POWER_UP = 0.1;
    private double CHANCE_BLOCK_COIN = 0.3;
    private double CHANCE_BLOCK_ENEMY = 0.2;
    private double CHANCE_WINGED = 0.5;
    private double CHANCE_COIN = 0.2;
    private double COIN_HEIGHT = 5.0;
    private double CHANCE_PLATFORM = 0.1;
    private double CHANCE_END_PLATFORM = 0.1;
    private int PLATFORM_HEIGHT = 4;
    private double CHANCE_ENEMY = 0.1;
    private double CHANCE_PIPE = 0.1;
    private int PIPE_MIN_HEIGHT = 2;
    private double PIPE_HEIGHT = 3.0;
    private int minX = 5;
    private double CHANCE_HILL = 0.1;
    private double CHANCE_END_HILL = 0.3;
    private double CHANCE_HILL_ENEMY = 0.3;
    private double HILL_HEIGHT = 4.0;
    private int GAP_LENGTH = 5;
    private double CHANGE_GAP = 0.1;
    private double CHANGE_HILL_CHANGE = 0.1;
    private double GAP_OFFSET = -5.0;
    private double GAP_RANGE = 10.0;
    private int GROUND_MAX_HEIGHT = 5;
    Random rand;
    int gapCount = 0;
    int turtleCount = 0;
    int coinBlockCount = 0;
    int xExit = 0;
    int yExit = 0;

    public LevelGenerator() {
        this(10, 7, 10);
    }

    public LevelGenerator(int n, int n2, int n3) {
        this.maxGaps = n;
        this.maxTurtles = n2;
        this.maxCoinBlocks = n3;
    }

    private void placeBlock(MarioLevelModel marioLevelModel, int n, int n2) {
        if (this.rand.nextDouble() < this.CHANCE_BLOCK_POWER_UP) {
            marioLevelModel.setBlock(n, n2, 'U');
        } else if (this.rand.nextDouble() < this.CHANCE_BLOCK_COIN && this.coinBlockCount < this.maxCoinBlocks) {
            marioLevelModel.setBlock(n, n2, 'C');
            ++this.coinBlockCount;
        } else {
            marioLevelModel.setBlock(n, n2, 'S');
        }
        if (this.rand.nextDouble() < this.CHANCE_BLOCK_ENEMY) {
            char c = MarioLevelModel.getEnemyCharacters(false)[this.rand.nextInt(MarioLevelModel.getEnemyCharacters(false).length)];
            if (c == 'k' || c == 'r') {
                if (this.turtleCount < this.maxTurtles) {
                    ++this.turtleCount;
                } else {
                    c = 'g';
                }
            }
            boolean bl = this.rand.nextDouble() < this.CHANCE_WINGED;
            marioLevelModel.setBlock(n, n2 - 1, MarioLevelModel.getWingedEnemyVersion(c, bl));
        }
    }

    private void placePipe(MarioLevelModel marioLevelModel, int n, int n2, int n3) {
        marioLevelModel.setRectangle(n, n2 - n3, 2, n3, 't');
    }

    private void setGroundHeight(MarioLevelModel marioLevelModel, int n, int n2, int n3, int n4) {
        int n5 = marioLevelModel.getHeight();
        marioLevelModel.setRectangle(n, n2 + 1, 1, n5 - 1 - n2, 'X');
        if (n2 < n3) {
            marioLevelModel.setBlock(n, n2, 'X');
            for (int i = n2 + 1; i <= n3; ++i) {
                marioLevelModel.setBlock(n, i, 'X');
            }
        } else if (n2 < n4) {
            marioLevelModel.setBlock(n, n2, 'X');
            for (int i = n2 + 1; i <= n4; ++i) {
                marioLevelModel.setBlock(n, i, 'X');
            }
        } else {
            marioLevelModel.setBlock(n, n2, 'X');
        }
        if (n == marioLevelModel.getWidth() - 5) {
            this.yExit = n2 - 1;
        }
    }

    @Override
    public String getGeneratedLevel(MarioLevelModel marioLevelModel, MarioTimer marioTimer) {
        boolean bl;
        char c;
        int n;
        int n2;
        int n3;
        this.rand = new Random();
        marioLevelModel.clearMap();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n4 = n3 = (n2 = this.GROUND_MAX_HEIGHT + (int)(this.rand.nextDouble() * (double)(marioLevelModel.getHeight() - 1 - this.GROUND_MAX_HEIGHT)));
        boolean bl2 = false;
        int n5 = 0;
        int n6 = marioLevelModel.getHeight() - 1;
        for (n = 0; n < marioLevelModel.getWidth(); ++n) {
            if (n5 > this.GAP_LENGTH && n3 >= marioLevelModel.getHeight()) {
                n4 = n6;
                bl2 = true;
                n5 = 1;
            } else if (n > this.minX && this.rand.nextDouble() < this.CHANGE_HILL_CHANGE && !bl2) {
                n4 += (int)(this.GAP_OFFSET + this.GAP_RANGE * this.rand.nextDouble());
                n4 = Math.min(marioLevelModel.getHeight() - 2, n4);
                n4 = Math.max(5, n4);
                bl2 = true;
                n5 = 1;
            } else if (n > this.minX && n3 < marioLevelModel.getHeight() && this.rand.nextDouble() < this.CHANGE_GAP && !bl2 && this.gapCount < this.maxGaps) {
                n6 = Math.min(marioLevelModel.getHeight() - 1, n2);
                n4 = marioLevelModel.getHeight();
                bl2 = true;
                n5 = 1;
                ++this.gapCount;
            } else {
                ++n5;
                bl2 = false;
            }
            this.setGroundHeight(marioLevelModel, n, n3, n2, n4);
            arrayList.add(n3);
            n2 = n3;
            n3 = n4;
        }
        n = 0;
        n3 = marioLevelModel.getHeight();
        for (Integer n7 : arrayList) {
            char c2;
            if (n3 == marioLevelModel.getHeight()) {
                if (n > 10 && this.rand.nextDouble() < this.CHANCE_HILL) {
                    n3 = (int)(this.HILL_HEIGHT + this.rand.nextDouble() * ((double)n7.intValue() - this.HILL_HEIGHT));
                    marioLevelModel.setBlock(n, n3, '%');
                    for (c2 = n3 + 1; c2 < n7; ++c2) {
                        marioLevelModel.setBlock(n, c2, '|');
                    }
                }
            } else if (n3 >= n7) {
                n3 = marioLevelModel.getHeight();
            } else if (this.rand.nextDouble() < this.CHANCE_END_HILL) {
                marioLevelModel.setBlock(n, n3, '%');
                for (c2 = n3 + 1; c2 < n7; ++c2) {
                    marioLevelModel.setBlock(n, c2, '|');
                }
                n3 = marioLevelModel.getHeight();
            } else {
                marioLevelModel.setBlock(n, n3, '%');
                for (c2 = n3 + 1; c2 < n7; ++c2) {
                    marioLevelModel.setBlock(n, c2, '|');
                }
                if (this.rand.nextDouble() < this.CHANCE_HILL_ENEMY) {
                    c2 = MarioLevelModel.getEnemyCharacters(false)[this.rand.nextInt(MarioLevelModel.getEnemyCharacters(false).length)];
                    if (c2 == 'k' || c2 == 'r') {
                        if (this.turtleCount < this.maxTurtles) {
                            ++this.turtleCount;
                        } else {
                            c2 = 'g';
                        }
                    }
                    boolean bl3 = this.rand.nextDouble() < this.CHANCE_WINGED;
                    marioLevelModel.setBlock(n, n3 - 1, MarioLevelModel.getWingedEnemyVersion(c2, bl3));
                }
            }
            ++n;
        }
        n2 = 0;
        int n8 = 0;
        n = 0;
        int n9 = 0;
        for (Integer n10 : arrayList) {
            if (n > this.minX && this.rand.nextDouble() < this.CHANCE_PIPE && n10 == n2 && n8 <= n2 && n > n9 + 1) {
                c = this.PIPE_MIN_HEIGHT + (int)(Math.random() * this.PIPE_HEIGHT);
                this.placePipe(marioLevelModel, n - 1, n10, c);
                n9 = n;
            }
            n8 = n2;
            n2 = n10;
            ++n;
        }
        n = 0;
        for (Integer n11 : arrayList) {
            if (n > this.minX && this.rand.nextDouble() < this.CHANCE_ENEMY) {
                c = MarioLevelModel.getEnemyCharacters(false)[this.rand.nextInt(MarioLevelModel.getEnemyCharacters(false).length)];
                if (c == 'k' || c == 'r') {
                    if (this.turtleCount < this.maxTurtles) {
                        ++this.turtleCount;
                    } else {
                        c = 'g';
                    }
                }
                bl = this.rand.nextDouble() < this.CHANCE_WINGED;
                char c3 = marioLevelModel.getBlock(n, n11 - 1);
                if (c3 == '-') {
                    marioLevelModel.setBlock(n, n11 - 1, MarioLevelModel.getWingedEnemyVersion(c, bl));
                }
            }
            ++n;
        }
        n = 0;
        n3 = marioLevelModel.getHeight();
        for (Integer n12 : arrayList) {
            c = '\u0000';
            for (c = '\u0000'; c < n12 && !(bl = marioLevelModel.getBlock(n, c)); ++c) {
            }
            if (n3 == marioLevelModel.getHeight()) {
                if (n > this.minX && this.rand.nextDouble() < this.CHANCE_PLATFORM) {
                    n3 = c - this.PLATFORM_HEIGHT;
                    if (n3 >= 1 && n12 - c > 1) {
                        this.placeBlock(marioLevelModel, n, n3);
                    } else {
                        n3 = marioLevelModel.getHeight();
                    }
                }
            } else if (n3 >= c + 1) {
                n3 = marioLevelModel.getHeight();
            } else if (this.rand.nextDouble() < this.CHANCE_END_PLATFORM) {
                this.placeBlock(marioLevelModel, n, n3);
                n3 = marioLevelModel.getHeight();
            } else {
                this.placeBlock(marioLevelModel, n, n3);
            }
            ++n;
        }
        n = 0;
        for (Integer n13 : arrayList) {
            if (n > 5 && this.rand.nextDouble() < this.CHANCE_COIN && (c = (char)marioLevelModel.getBlock(n, n3 = n13 - (int)(1.0 + Math.random() * this.COIN_HEIGHT))) == '-') {
                marioLevelModel.setBlock(n, n3, 'o');
            }
            ++n;
        }
        this.xExit = marioLevelModel.getWidth() - 5;
        marioLevelModel.setBlock(this.xExit, this.yExit, 'F');
        return marioLevelModel.getMap();
    }

    @Override
    public String getGeneratorName() {
        return "BenWeberLevelGenerator";
    }
}

