/*
 * Decompiled with CFR 0.152.
 */
package agents.andySloane;

import agents.andySloane.MarioMath;
import agents.andySloane.MarioState;
import agents.andySloane.MarioStateComparator;
import agents.andySloane.Sensors;
import agents.andySloane.Tunables;
import agents.andySloane.WorldState;
import engine.core.MarioAgent;
import engine.core.MarioForwardModel;
import engine.core.MarioTimer;
import engine.helper.MarioActions;
import java.util.Comparator;

public abstract class HeuristicSearchingAgent
implements MarioAgent {
    public static final Comparator<MarioState> msComparator = new MarioStateComparator();
    protected final boolean[] action = new boolean[MarioActions.numberOfActions()];
    protected int[] marioPosition = null;
    protected Sensors sensors = new Sensors();
    protected static final boolean stdinSingleStep = false;
    MarioState ms = null;
    MarioState ms_prev = null;
    WorldState ws = null;
    float pred_x;
    float pred_y;
    boolean won = false;

    protected final float cost(MarioState marioState, MarioState marioState2) {
        float f;
        float f2 = Tunables.HurtCost * (float)marioState.hurt;
        if (marioState.dead) {
            return Tunables.DeadCost;
        }
        int n = (int)marioState.x / 16 - marioState.ws.MapX;
        int n2 = (int)marioState.y / 16 - marioState.ws.MapY;
        int n3 = 15;
        float f3 = (n3 + marioState.ws.MapX) * 16 + 8;
        if (marioState.x > f3) {
            return (f3 - marioState.x) / 9.71f;
        }
        float f4 = MarioMath.stepsToRun(f3 - marioState.x, marioState.xa);
        if (n < 0 || n >= 22) {
            return f4 + f2;
        }
        int n4 = 22;
        int n5 = n;
        for (int i = n; i <= n3; ++i) {
            if (marioState.ws.heightmap[i] >= n4) continue;
            n4 = marioState.ws.heightmap[i];
            n5 = i;
        }
        float f5 = (n4 + marioState.ws.MapY) * 16 - 1;
        float f6 = (n5 + marioState.ws.MapX) * 16 - 4;
        if (marioState.onGround) {
            if (marioState.y <= f5) {
                return f2 + f4;
            }
            float f7 = MarioMath.stepsToJump(marioState.y - f5);
            float f8 = MarioMath.stepsToRun(f6 - marioState.x, marioState.xa);
            float f9 = MarioMath.stepsToRun(f3 - f6, marioState.xa);
            return f2 + Math.max(f7, f8) + f9;
        }
        MarioState marioState3 = marioState.clone();
        MarioState marioState4 = marioState.clone();
        float f10 = marioState3.y;
        int n6 = 0;
        int n7 = 0;
        while (!marioState3.dead && !marioState3.onGround) {
            marioState3.move(MarioState.ACT_SPEED | MarioState.ACT_LEFT | MarioState.ACT_JUMP);
        }
        while (!marioState4.dead && !marioState4.onGround) {
            marioState4.move(MarioState.ACT_SPEED | MarioState.ACT_RIGHT | MarioState.ACT_JUMP);
            ++n7;
            if (!(marioState4.y <= f10)) continue;
            f10 = marioState4.y;
            n6 = n7;
        }
        if (marioState4.dead && marioState3.dead) {
            return Tunables.DeadCost;
        }
        if (MarioMath.canReachLedge(marioState.x, marioState.xa, n6, f10, f6, f5)) {
            return f2 + f4;
        }
        int n8 = 22;
        for (f = marioState3.x; f <= marioState4.x; f += 16.0f) {
            int n9 = (int)f / 16 - marioState.ws.MapX;
            if (n9 < 0 || n9 >= 16 || marioState.ws.heightmap[n9] >= n8 || marioState.ws.heightmap[n9] < n2) continue;
            n8 = marioState.ws.heightmap[n9];
        }
        f = (n8 + marioState.ws.MapY) * 16 - 1;
        float f11 = 0.0f;
        float f12 = MarioMath.stepsToJump(f5 - f);
        float f13 = MarioMath.stepsToRun(f6 - marioState.x, marioState.xa);
        float f14 = MarioMath.stepsToRun(f3 - f6, marioState.xa);
        return f2 + Math.max(f11 + f12, f13) + f14;
    }

    public static final boolean useless_action(int n, MarioState marioState) {
        if ((n & MarioState.ACT_SPEED) > 0 && (n & MarioState.ACT_LEFT) <= 0 && (n & MarioState.ACT_RIGHT) <= 0) {
            return true;
        }
        if ((n & MarioState.ACT_LEFT) > 0 && (n & MarioState.ACT_RIGHT) > 0) {
            return true;
        }
        if ((n & MarioState.ACT_JUMP) > 0) {
            if (marioState.jumpTime == 0 && !marioState.mayJump) {
                return true;
            }
            if (marioState.jumpTime <= 0 && !marioState.onGround && !marioState.sliding) {
                return true;
            }
        }
        int n2 = (int)marioState.x;
        if ((n & MarioState.ACT_RIGHT) > 0 && marioState.xa == 0.0f && marioState.x - (float)n2 == 0.0f && (n2 & 0xF) == 11) {
            return marioState.ws.isBlocking((n2 + 5) / 16, (int)(marioState.y / 16.0f), 1.0f, marioState.ya) || marioState.ws.isBlocking((n2 + 5) / 16, (int)(marioState.y / 16.0f) - 1, 1.0f, marioState.ya) || marioState.ws.isBlocking((n2 + 5) / 16, (int)(marioState.y / 16.0f) - 2, 1.0f, marioState.ya);
        }
        return false;
    }

    protected abstract int searchForAction(MarioState var1, WorldState var2);

    public static MarioState marioMin(MarioState marioState, MarioState marioState2) {
        if (marioState == null) {
            return marioState2;
        }
        if (marioState2 == null) {
            return marioState;
        }
        if (marioState.cost - marioState.g <= marioState2.cost - marioState2.g) {
            return marioState;
        }
        return marioState2;
    }

    @Override
    public void initialize(MarioForwardModel marioForwardModel, MarioTimer marioTimer) {
        this.ms = null;
        this.marioPosition = null;
        this.won = false;
    }

    @Override
    public boolean[] getActions(MarioForwardModel marioForwardModel, MarioTimer marioTimer) {
        if (this.won) {
            return this.action;
        }
        this.sensors.updateReadings(marioForwardModel);
        this.marioPosition = this.sensors.getMarioPosition();
        float[] fArray = marioForwardModel.getMarioFloatPos();
        if (this.ms == null) {
            this.ms = new MarioState(fArray[0], fArray[1], 0.0f, 3.0f);
            this.ws = new WorldState(this.sensors.levelScene, this.ms, marioForwardModel.getEnemiesFloatPos());
        } else {
            if (!(fArray[0] == this.pred_x && fArray[1] == this.pred_y || HeuristicSearchingAgent.epsilon(fArray[0], this.pred_x) && HeuristicSearchingAgent.epsilon(fArray[1], this.pred_y) || !(fArray[0] > 4000.0f) || fArray[0] != this.ms_prev.x || fArray[1] != this.ms_prev.y)) {
                this.won = true;
                return this.action;
            }
            this.resync(marioForwardModel, !HeuristicSearchingAgent.epsilon(fArray[0], this.pred_x), !HeuristicSearchingAgent.epsilon(fArray[1], this.pred_y));
            this.ms.ws.sync(this.ws, this.sensors.levelScene, this.ms, marioForwardModel.getEnemiesFloatPos());
            this.ws = this.ms.ws;
        }
        this.ms.mayJump = marioForwardModel.mayMarioJump();
        this.ms.onGround = marioForwardModel.isMarioOnGround();
        this.ms.big = marioForwardModel.getMarioMode() > 0;
        int n = this.searchForAction(this.ms, this.ws);
        this.ms_prev = this.ms;
        this.ms = this.ms.next(n, this.ws);
        this.pred_x = this.ms.x;
        this.pred_y = this.ms.y;
        this.action[MarioActions.SPEED.getValue()] = (n & MarioState.ACT_SPEED) != 0;
        this.action[MarioActions.RIGHT.getValue()] = (n & MarioState.ACT_RIGHT) != 0;
        this.action[MarioActions.LEFT.getValue()] = (n & MarioState.ACT_LEFT) != 0;
        this.action[MarioActions.JUMP.getValue()] = (n & MarioState.ACT_JUMP) != 0;
        return this.action;
    }

    private static boolean epsilon(float f, float f2) {
        return (double)Math.abs(f - f2) < 0.01;
    }

    private void resync(MarioForwardModel marioForwardModel, boolean bl, boolean bl2) {
        float[] fArray = marioForwardModel.getMarioFloatPos();
        this.ms.x = fArray[0];
        this.ms.y = fArray[1];
        if (this.ms_prev != null) {
            if (bl) {
                this.ms.xa = (this.ms.x - this.ms_prev.x) * 0.89f;
            }
            if (bl2) {
                this.ms.ya = (this.ms.y - this.ms_prev.y) * 0.85f;
            }
        }
    }

    @Override
    public String getAgentName() {
        return "AndySloaneAgent";
    }
}

