/*
 * Decompiled with CFR 0.152.
 */
package agents.andySloane;

import agents.andySloane.SpriteState;
import agents.andySloane.Tunables;
import agents.andySloane.WorldState;

public final class MarioState
extends SpriteState {
    public int jumpTime = 0;
    public int invulnerableTime = 0;
    public int hurt = 0;
    public boolean big = true;
    public boolean dead = false;
    public boolean hurtThisStep = false;
    public boolean fire = true;
    public boolean wasOnGround = false;
    public boolean mayJump = true;
    public boolean sliding = false;
    public float xJumpSpeed = 0.0f;
    public float yJumpSpeed = 0.0f;
    public static int ACT_SPEED = 1;
    public static int ACT_RIGHT = 2;
    public static int ACT_LEFT = 4;
    public static int ACT_JUMP = 8;
    public static int[] jumpstep_table = new int[]{0, 1, 2, 4, 7};
    public float g;
    public float cost;
    public int root_action;
    public WorldState ws;
    public int action;
    public MarioState pred;

    public MarioState(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.xa = f3;
        this.ya = f4;
    }

    @Override
    public float height() {
        return this.big ? 24.0f : 12.0f;
    }

    public void print() {
        System.out.printf("g=%d a:%d x:(%f,%f) v:(%f,%f) %s%s%s cost=%f\n", (int)this.g, this.action, Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.xa), Float.valueOf(this.ya), this.onGround ? "G" : "g", this.mayJump ? "J" : "j", this.sliding ? "S" : "s", Float.valueOf(this.cost));
    }

    @Override
    public MarioState clone() {
        MarioState marioState = new MarioState(this.x, this.y, this.xa, this.ya);
        marioState.facing = this.facing;
        marioState.jumpTime = this.jumpTime;
        marioState.big = this.big;
        marioState.fire = this.fire;
        marioState.dead = this.dead;
        marioState.hurt = this.hurt;
        this.hurtThisStep = false;
        marioState.onGround = this.onGround;
        marioState.wasOnGround = this.onGround;
        marioState.mayJump = this.mayJump;
        marioState.sliding = this.sliding;
        marioState.xJumpSpeed = this.xJumpSpeed;
        marioState.yJumpSpeed = this.yJumpSpeed;
        marioState.root_action = this.root_action;
        marioState.invulnerableTime = this.invulnerableTime;
        marioState.ws = this.ws;
        return marioState;
    }

    public MarioState next(int n, WorldState worldState) {
        MarioState marioState = this.clone();
        marioState.action = n;
        marioState.pred = this;
        marioState.g = this.g + Tunables.GIncrement;
        marioState.ws = worldState;
        marioState.move(n);
        if (!this.hurtThisStep) {
            marioState.ws = marioState.ws.step();
            marioState.ws = marioState.ws.interact(marioState, false);
        }
        return marioState;
    }

    public void move(int n) {
        float f;
        boolean bl = false;
        float f2 = f = (n & ACT_SPEED) != 0 ? 1.2f : 0.6f;
        if (this.invulnerableTime > 0) {
            --this.invulnerableTime;
        }
        if (this.xa > 2.0f) {
            this.facing = 1;
        } else if (this.xa < -2.0f) {
            this.facing = -1;
        }
        if ((n & ACT_JUMP) != 0 || this.jumpTime < 0 && !this.onGround && !this.sliding) {
            if (this.jumpTime < 0) {
                this.xa = this.xJumpSpeed;
                this.ya = (float)(-this.jumpTime) * this.yJumpSpeed;
                ++this.jumpTime;
            } else if (this.onGround && this.mayJump) {
                this.xJumpSpeed = 0.0f;
                this.yJumpSpeed = -1.9f;
                this.jumpTime = 7;
                this.ya = (float)this.jumpTime * this.yJumpSpeed;
                this.onGround = false;
                this.sliding = false;
            } else if (this.sliding && this.mayJump) {
                this.xJumpSpeed = (float)(-this.facing) * 6.0f;
                this.yJumpSpeed = -2.0f;
                this.jumpTime = -6;
                this.xa = this.xJumpSpeed;
                this.ya = (float)(-this.jumpTime) * this.yJumpSpeed;
                this.onGround = false;
                this.sliding = false;
                this.facing = -this.facing;
            } else if (this.jumpTime > 0) {
                this.xa += this.xJumpSpeed;
                this.ya = (float)this.jumpTime * this.yJumpSpeed;
                --this.jumpTime;
            }
        } else {
            this.jumpTime = 0;
        }
        if ((n & ACT_LEFT) != 0 && !bl) {
            if (this.facing == 1) {
                this.sliding = false;
            }
            this.xa -= f;
            if (this.jumpTime >= 0) {
                this.facing = -1;
            }
        }
        if ((n & ACT_RIGHT) != 0 && !bl) {
            if (this.facing == -1) {
                this.sliding = false;
            }
            this.xa += f;
            if (this.jumpTime >= 0) {
                this.facing = 1;
            }
        }
        if ((n & ACT_LEFT) == 0 && (n & ACT_RIGHT) == 0 || bl || this.ya < 0.0f || this.onGround) {
            this.sliding = false;
        }
        boolean bl2 = this.mayJump = (this.onGround || this.sliding) && (n & ACT_JUMP) == 0;
        if (Math.abs(this.xa) < 0.5f) {
            this.xa = 0.0f;
        }
        if (this.sliding) {
            this.ya *= 0.5f;
        }
        this.onGround = false;
        this.move(this.xa, 0.0f);
        this.move(0.0f, this.ya);
        if (this.y > 256.0f) {
            this.dead = true;
        }
        if (this.x < 0.0f) {
            this.x = 0.0f;
            this.xa = 0.0f;
        }
        this.xa *= 0.89f;
        this.ya *= 0.85f;
        if (!this.onGround) {
            this.ya += 3.0f;
        }
    }

    private boolean move(float f, float f2) {
        int n;
        while (f > 8.0f) {
            if (!this.move(8.0f, 0.0f)) {
                return false;
            }
            f -= 8.0f;
        }
        while (f < -8.0f) {
            if (!this.move(-8.0f, 0.0f)) {
                return false;
            }
            f += 8.0f;
        }
        while (f2 > 8.0f) {
            if (!this.move(0.0f, 8.0f)) {
                return false;
            }
            f2 -= 8.0f;
        }
        while (f2 < -8.0f) {
            if (!this.move(0.0f, -8.0f)) {
                return false;
            }
            f2 += 8.0f;
        }
        boolean bl = false;
        int n2 = 4;
        int n3 = n = this.big ? 24 : 12;
        if (f2 > 0.0f) {
            if (this.isBlocking(this.x + f - (float)n2, this.y + f2, f, 0.0f)) {
                bl = true;
            } else if (this.isBlocking(this.x + f + (float)n2, this.y + f2, f, 0.0f)) {
                bl = true;
            } else if (this.isBlocking(this.x + f - (float)n2, this.y + f2 + 1.0f, f, f2)) {
                bl = true;
            } else if (this.isBlocking(this.x + f + (float)n2, this.y + f2 + 1.0f, f, f2)) {
                bl = true;
            }
        }
        if (f2 < 0.0f) {
            if (this.isBlocking(this.x + f, this.y + f2 - (float)n, f, f2)) {
                bl = true;
            } else if (bl || this.isBlocking(this.x + f - (float)n2, this.y + f2 - (float)n, f, f2)) {
                bl = true;
            } else if (bl || this.isBlocking(this.x + f + (float)n2, this.y + f2 - (float)n, f, f2)) {
                bl = true;
            }
        }
        if (f > 0.0f) {
            this.sliding = true;
            if (this.isBlocking(this.x + f + (float)n2, this.y + f2 - (float)n, f, f2)) {
                bl = true;
            } else {
                this.sliding = false;
            }
            if (this.isBlocking(this.x + f + (float)n2, this.y + f2 - (float)(n / 2), f, f2)) {
                bl = true;
            } else {
                this.sliding = false;
            }
            if (this.isBlocking(this.x + f + (float)n2, this.y + f2, f, f2)) {
                bl = true;
            } else {
                this.sliding = false;
            }
        }
        if (f < 0.0f) {
            this.sliding = true;
            if (this.isBlocking(this.x + f - (float)n2, this.y + f2 - (float)n, f, f2)) {
                bl = true;
            } else {
                this.sliding = false;
            }
            if (this.isBlocking(this.x + f - (float)n2, this.y + f2 - (float)(n / 2), f, f2)) {
                bl = true;
            } else {
                this.sliding = false;
            }
            if (this.isBlocking(this.x + f - (float)n2, this.y + f2, f, f2)) {
                bl = true;
            } else {
                this.sliding = false;
            }
        }
        if (bl) {
            if (f < 0.0f) {
                this.x = (int)((this.x - (float)n2) / 16.0f) * 16 + n2;
                this.xa = 0.0f;
            } else if (f > 0.0f) {
                this.x = (int)((this.x + (float)n2) / 16.0f + 1.0f) * 16 - n2 - 1;
                this.xa = 0.0f;
            }
            if (f2 < 0.0f) {
                this.y = (int)((this.y - (float)n) / 16.0f) * 16 + n;
                this.jumpTime = 0;
                this.ya = 0.0f;
            } else if (f2 > 0.0f) {
                this.y = (int)((this.y - 1.0f) / 16.0f + 1.0f) * 16 - 1;
                this.onGround = true;
            }
            return false;
        }
        this.x += f;
        this.y += f2;
        return true;
    }

    private boolean isBlocking(float f, float f2, float f3, float f4) {
        int n = (int)(f / 16.0f);
        int n2 = (int)(f2 / 16.0f);
        int n3 = (int)(this.x / 16.0f);
        int n4 = (int)(this.y / 16.0f);
        if (n == n3 && n2 == n4) {
            return false;
        }
        boolean bl = this.ws.isBlocking(n, n2, f3, f4);
        int n5 = this.ws.getBlock(n, n2);
        if (n5 == 34) {
            this.ws = this.ws.removeTile(n, n2);
            return false;
        }
        if (bl && f4 < 0.0f) {
            this.ws = this.ws.bump(n, n2, this.big);
        }
        return bl;
    }

    public void stomp(SpriteState spriteState) {
        float f = spriteState.y - spriteState.height() / 2.0f;
        this.move(0.0f, f - this.y);
        this.xJumpSpeed = 0.0f;
        this.yJumpSpeed = -1.9f;
        this.jumpTime = 8;
        this.ya = (float)this.jumpTime * this.yJumpSpeed;
        this.onGround = false;
        this.sliding = false;
        this.invulnerableTime = 1;
    }

    public void getHurt() {
        if (this.invulnerableTime > 0) {
            return;
        }
        if (this.big) {
            if (this.fire) {
                this.fire = false;
            } else {
                this.big = false;
            }
            this.invulnerableTime = 32;
        } else {
            this.dead = true;
        }
        ++this.hurt;
        this.hurtThisStep = true;
    }

    public int marioMode() {
        return (this.big ? 1 : 0) + (this.fire ? 1 : 0);
    }
}

