/*
 * Decompiled with CFR 0.152.
 */
package agents.andySloane;

import agents.andySloane.MarioState;
import agents.andySloane.ShellState;
import agents.andySloane.SpriteState;
import java.util.HashMap;
import java.util.Vector;

public final class WorldState {
    public int[][] map;
    public int[] heightmap;
    public int MapX;
    public int MapY;
    public Vector<SpriteState> enemies;
    public Vector<SpriteState> addqueue;
    WorldState pred = null;
    HashMap<WSHashKey, WorldState> succ;

    public WorldState(int[][] nArray, MarioState marioState, float[] fArray) {
        this.map = nArray;
        this.MapX = (int)marioState.x / 16 - 8;
        this.MapY = (int)marioState.y / 16 - 8;
        this.succ = new HashMap();
        this.enemies = new Vector();
        this.buildHeightMap();
        this.syncEnemies(this, fArray, marioState);
    }

    WorldState() {
    }

    public WorldState clone() {
        WorldState worldState = new WorldState();
        worldState.map = this.map;
        worldState.MapX = this.MapX;
        worldState.MapY = this.MapY;
        worldState.heightmap = this.heightmap;
        worldState.succ = new HashMap();
        worldState.enemies = this.enemies;
        worldState.addqueue = this.addqueue;
        return worldState;
    }

    public WorldState step() {
        WSHashKey wSHashKey = new WSHashKey();
        WorldState worldState = this.succ.get(wSHashKey);
        if (worldState == null) {
            worldState = this.clone();
            worldState.enemies = (Vector)this.enemies.clone();
            worldState.stepEnemies();
            this.succ.put(wSHashKey, worldState);
        }
        return worldState;
    }

    public void sync(WorldState worldState, int[][] nArray, MarioState marioState, float[] fArray) {
        this.map = nArray;
        this.MapX = (int)marioState.x / 16 - 8;
        this.MapY = (int)marioState.y / 16 - 8;
        this.buildHeightMap();
        this.succ.clear();
        this.syncEnemies(worldState, fArray, marioState);
    }

    void buildHeightMap() {
        this.heightmap = new int[16];
        for (int i = 0; i < 16; ++i) {
            int n;
            for (n = 15; n >= 0 && this.map[n][i] == 0; --n) {
            }
            if (n < 0 || n + this.MapY < 8) {
                this.heightmap[i] = 22;
                continue;
            }
            while (n >= 0 && this.map[n][i] != 0 && this.map[n][i] != 1) {
                --n;
            }
            this.heightmap[i] = n + 1;
        }
    }

    void _removeTile(WSHashKey wSHashKey, int n, int n2) {
        int[][] nArray = new int[16][16];
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                nArray[j][i] = this.map[j][i];
            }
        }
        nArray[n][n2] = 0;
        this.map = nArray;
    }

    public void syncEnemies(WorldState worldState, float[] fArray, MarioState marioState) {
        EnemyObservation[] enemyObservationArray = new EnemyObservation[fArray.length / 3];
        for (int i = 0; i < fArray.length; i += 3) {
            enemyObservationArray[i / 3] = new EnemyObservation((int)fArray[i], fArray[i + 1], fArray[i + 2]);
        }
        Vector<SpriteState> vector = new Vector<SpriteState>(this.enemies.size() + 2);
        Vector<SpriteState> vector2 = worldState.enemies;
        for (EnemyObservation enemyObservation : enemyObservationArray) {
            SpriteState spriteState = null;
            float f = Float.POSITIVE_INFINITY;
            int n = 0;
            for (int i = 0; i < this.enemies.size(); ++i) {
                SpriteState spriteState2 = this.enemies.get(i);
                if (spriteState2.type != enemyObservation.type) continue;
                float f2 = spriteState2.x - enemyObservation.x;
                float f3 = spriteState2.y - enemyObservation.y;
                float f4 = f2 * f2 + f3 * f3;
                if (spriteState != null && !(f4 < f)) continue;
                spriteState = spriteState2;
                f = f4;
                n = i;
            }
            if (spriteState == null || f > 64.0f) {
                spriteState = SpriteState.newEnemy(enemyObservation.x, enemyObservation.y, enemyObservation.type, marioState);
            } else if (f != 0.0f) {
                if (n >= vector2.size()) {
                    spriteState = SpriteState.newEnemy(enemyObservation.x, enemyObservation.y, enemyObservation.type, marioState);
                } else {
                    SpriteState spriteState3 = vector2.get(n);
                    spriteState.resync(enemyObservation.x, enemyObservation.y, spriteState3.x, spriteState3.y);
                }
            }
            if (spriteState == null) continue;
            vector.add(spriteState);
        }
        this.enemies = vector;
    }

    public void stepEnemies() {
        for (int i = 0; i < this.enemies.size(); ++i) {
            SpriteState spriteState = this.enemies.get(i).clone();
            boolean bl = spriteState.move(this);
            if (bl) {
                this.enemies.set(i, spriteState);
                continue;
            }
            this.enemies.remove(i);
            --i;
        }
    }

    public WorldState interact(MarioState marioState, boolean bl) {
        WorldState worldState = this;
        worldState.addqueue = new Vector();
        if (bl) {
            System.out.printf("--interact\n", new Object[0]);
        }
        for (int i = 0; i < worldState.enemies.size(); ++i) {
            worldState = worldState.enemies.get(i).collideCheck(worldState, marioState);
        }
        for (SpriteState spriteState : worldState.addqueue) {
            if (bl) {
                System.out.printf("interact: new e t=%d xy=%f,%f xaya=%f,%f deadTime=%d\n", spriteState.type, Float.valueOf(spriteState.x), Float.valueOf(spriteState.y), Float.valueOf(spriteState.xa), Float.valueOf(spriteState.ya), spriteState.deadTime);
            }
            worldState.enemies.add(spriteState);
        }
        worldState.addqueue = null;
        return worldState;
    }

    public void addShell(float f, float f2) {
        ShellState shellState = new ShellState(f, f2, true);
        shellState.move(this);
        this.addqueue.add(shellState);
    }

    WorldState removeTile(int n, int n2) {
        if ((n -= this.MapX) < 0 || n >= 16 || (n2 -= this.MapY) < 0 || n2 >= 16) {
            return this;
        }
        WSHashKey wSHashKey = new WSHashKey(n * 16 + n2);
        WorldState worldState = this.succ.get(wSHashKey);
        if (worldState == null) {
            worldState = this.clone();
            worldState._removeTile(wSHashKey, n, n2);
            this.succ.put(wSHashKey, worldState);
        }
        return worldState;
    }

    final int getBlock(int n, int n2) {
        if ((n -= this.MapX) < 0 || n >= 16 || (n2 -= this.MapY) < 0 || n2 >= 16) {
            return 0;
        }
        return this.map[n][n2];
    }

    final boolean isBlocking(int n, int n2, float f, float f2) {
        int n3 = this.getBlock(n, n2);
        if (n3 == 1) {
            return false;
        }
        if (n3 == 34) {
            return false;
        }
        if (n3 == -11) {
            return f2 > 0.0f;
        }
        return n3 != 0;
    }

    final WorldState stomp(SpriteState spriteState, MarioState marioState) {
        marioState.stomp(spriteState);
        WorldState worldState = this.clone();
        worldState.enemies = (Vector)this.enemies.clone();
        worldState.enemies.set(worldState.enemies.indexOf(spriteState), spriteState.stomp(this, marioState));
        return worldState;
    }

    final WorldState bump(int n, int n2, boolean bl) {
        if (bl) {
            switch (this.getBlock(n, n2)) {
                case 16: {
                    return this.removeTile(n, n2);
                }
            }
        }
        return this;
    }

    final void checkShellCollide(ShellState shellState) {
    }

    final void kick(ShellState shellState) {
    }

    private static class EnemyObservation
    implements Comparable<EnemyObservation> {
        int type;
        float x;
        float y;

        EnemyObservation(int n, float f, float f2) {
            this.type = n;
            this.x = f;
            this.y = f2;
        }

        @Override
        public int compareTo(EnemyObservation enemyObservation) {
            return this.x < enemyObservation.x ? -1 : (this.x > enemyObservation.x ? 1 : 0);
        }
    }

    private class WSHashKey {
        static final int MOD_NONE = 0;
        static final int MOD_REMOVETILE = 1;
        static final int MOD_STOMP = 2;
        public int modType = 0;
        public int modTile = 0;
        public SpriteState modEnemy = null;

        WSHashKey() {
            this.modType = 0;
        }

        WSHashKey(int n) {
            this.modType = 1;
            this.modTile = n;
        }

        public int hashCode() {
            switch (this.modType) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1 + this.modTile * 4;
                }
                case 2: {
                    return 2 + this.modEnemy.hashCode() * 4;
                }
            }
            return -1;
        }

        public boolean equals(Object object) {
            WSHashKey wSHashKey = (WSHashKey)object;
            if (wSHashKey.modType != this.modType) {
                return false;
            }
            if (wSHashKey.modTile != this.modTile) {
                return false;
            }
            return wSHashKey.modEnemy == this.modEnemy;
        }
    }
}

