/*
 * Decompiled with CFR 0.152.
 */
package agents.glennHartmann;

import engine.core.MarioAgent;
import engine.core.MarioForwardModel;
import engine.core.MarioTimer;
import engine.helper.MarioActions;

public class Agent
implements MarioAgent {
    private boolean[] action = new boolean[MarioActions.numberOfActions()];
    private int jumpCount = 0;
    private int speedCount = 0;

    private boolean safeToJumpFromEnemies(byte[][] byArray) {
        for (int i = 5; i <= 9; ++i) {
            for (int j = 11; j <= 14; ++j) {
                if (j == 8 && i == 8 || byArray[j][i] != 1) continue;
                return false;
            }
        }
        return true;
    }

    private boolean safeToJumpFromGaps(byte[][] byArray) {
        for (int i = 9; i <= 9; ++i) {
            boolean bl = false;
            for (int j = 11; j <= 14; ++j) {
                if (byArray[j][i] != 1) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private boolean dangerFromEnemies(byte[][] byArray) {
        for (int i = 7; i <= 9; ++i) {
            for (int j = 8; j <= 12; ++j) {
                if (j == 8 && i == 8 || byArray[j][i] != 1) continue;
                return true;
            }
        }
        return false;
    }

    private boolean dangerFromGaps(byte[][] byArray) {
        for (int i = 9; i <= 10; ++i) {
            for (int j = 9; j <= 12; ++j) {
                if (byArray[j][i] != 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean safeToJump(byte[][] byArray, byte[][] byArray2) {
        return this.safeToJumpFromGaps(byArray) && this.safeToJumpFromEnemies(byArray2);
    }

    private boolean block(byte[][] byArray) {
        for (int i = 8; i <= 8; ++i) {
            for (int j = 9; j <= 12; ++j) {
                if (byArray[j][i] != 1) continue;
                return true;
            }
        }
        return false;
    }

    private byte[][] decode(MarioForwardModel marioForwardModel, int[][] nArray) {
        int n;
        int n2;
        marioForwardModel.getClass();
        marioForwardModel.getClass();
        byte[][] byArray = new byte[16][16];
        for (n2 = 0; n2 < byArray.length; ++n2) {
            for (n = 0; n < byArray[0].length; ++n) {
                byArray[n2][n] = 2;
            }
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            for (n = 0; n < nArray[n2].length; ++n) {
                byArray[n2][n] = nArray[n2][n] != 0 ? (byte)1 : 0;
            }
        }
        return byArray;
    }

    @Override
    public void initialize(MarioForwardModel marioForwardModel, MarioTimer marioTimer) {
        this.action = new boolean[MarioActions.numberOfActions()];
        this.action[MarioActions.RIGHT.getValue()] = true;
        this.action[MarioActions.SPEED.getValue()] = true;
        this.action[MarioActions.JUMP.getValue()] = false;
    }

    @Override
    public boolean[] getActions(MarioForwardModel marioForwardModel, MarioTimer marioTimer) {
        byte[][] byArray = this.decode(marioForwardModel, marioForwardModel.getMarioSceneObservation());
        byte[][] byArray2 = this.decode(marioForwardModel, marioForwardModel.getMarioEnemiesObservation());
        if (this.action[MarioActions.JUMP.getValue()] && this.jumpCount >= 8) {
            this.action[MarioActions.JUMP.getValue()] = false;
            this.jumpCount = 0;
        } else if (this.action[MarioActions.JUMP.getValue()]) {
            ++this.jumpCount;
        } else if (((this.dangerFromEnemies(byArray2) || this.block(byArray)) && this.safeToJump(byArray, byArray2) || this.dangerFromGaps(byArray)) && marioForwardModel.mayMarioJump()) {
            this.action[MarioActions.JUMP.getValue()] = true;
        }
        if (this.action[MarioActions.SPEED.getValue()] && this.speedCount >= 10) {
            this.action[MarioActions.SPEED.getValue()] = false;
            this.speedCount = 0;
        } else if (this.action[MarioActions.SPEED.getValue()]) {
            ++this.speedCount;
        } else {
            this.action[MarioActions.SPEED.getValue()] = true;
        }
        return this.action;
    }

    @Override
    public String getAgentName() {
        return "GlennHartmannAgent";
    }
}

