/*
 * Decompiled with CFR 0.152.
 */
package agents.robinBaumgarten;

import agents.robinBaumgarten.Helper;
import engine.core.MarioForwardModel;
import engine.helper.GameStatus;
import java.util.ArrayList;

public class SearchNode {
    public int timeElapsed = 0;
    public float remainingTimeEstimated = 0.0f;
    public float remainingTime = 0.0f;
    public SearchNode parentPos = null;
    public MarioForwardModel sceneSnapshot = null;
    public int distanceFromOrigin = 0;
    public boolean hasBeenHurt = false;
    public boolean isInVisitedList = false;
    boolean[] action;
    int repetitions = 1;

    public float calcRemainingTime(float f, float f2) {
        return (100000.0f - (this.maxForwardMovement(f2, 1000) + f)) / 10.909091f - 1000.0f;
    }

    public float getRemainingTime() {
        if (this.remainingTime > 0.0f) {
            return this.remainingTime;
        }
        return this.remainingTimeEstimated;
    }

    public float estimateRemainingTimeChild(boolean[] blArray, int n) {
        float[] fArray = Helper.estimateMaximumForwardMovement(this.sceneSnapshot.getMarioFloatVelocity()[0], blArray, n);
        return this.calcRemainingTime(this.sceneSnapshot.getMarioFloatPos()[0] + fArray[0], fArray[1]);
    }

    public SearchNode(boolean[] blArray, int n, SearchNode searchNode) {
        this.parentPos = searchNode;
        if (searchNode != null) {
            this.remainingTimeEstimated = searchNode.estimateRemainingTimeChild(blArray, n);
            this.distanceFromOrigin = searchNode.distanceFromOrigin + 1;
        }
        this.action = blArray;
        this.repetitions = n;
        this.timeElapsed = searchNode != null ? searchNode.timeElapsed + n : 0;
    }

    public void initializeRoot(MarioForwardModel marioForwardModel) {
        if (this.parentPos == null) {
            this.sceneSnapshot = marioForwardModel.clone();
            this.remainingTimeEstimated = this.calcRemainingTime(marioForwardModel.getMarioFloatPos()[0], 0.0f);
        }
    }

    public float simulatePos() {
        int n;
        this.sceneSnapshot = this.parentPos.sceneSnapshot.clone();
        for (n = 0; n < this.repetitions; ++n) {
            this.sceneSnapshot.advance(this.action);
        }
        n = Helper.getMarioDamage(this.sceneSnapshot, this.parentPos.sceneSnapshot);
        this.remainingTime = this.calcRemainingTime(this.sceneSnapshot.getMarioFloatPos()[0], this.sceneSnapshot.getMarioFloatVelocity()[0]) + (float)(n * (1000000 - 100 * this.distanceFromOrigin));
        if (this.isInVisitedList) {
            this.remainingTime += 1500.0f;
        }
        this.hasBeenHurt = n != 0;
        return this.remainingTime;
    }

    public ArrayList<SearchNode> generateChildren() {
        ArrayList<SearchNode> arrayList = new ArrayList<SearchNode>();
        ArrayList<boolean[]> arrayList2 = Helper.createPossibleActions(this);
        if (this.isLeafNode()) {
            arrayList2.clear();
        }
        for (boolean[] blArray : arrayList2) {
            arrayList.add(new SearchNode(blArray, this.repetitions, this));
        }
        return arrayList;
    }

    public boolean isLeafNode() {
        if (this.sceneSnapshot == null) {
            return false;
        }
        return this.sceneSnapshot.getGameStatus() != GameStatus.RUNNING;
    }

    private float maxForwardMovement(float f, int n) {
        float f2 = n;
        float f3 = f;
        return (float)(99.17355373 * Math.pow(0.89, f2 + 1.0f) - 9.090909091 * (double)f3 * Math.pow(0.89, f2 + 1.0f) + 10.90909091 * (double)f2 - 88.26446282 + 9.090909091 * (double)f3);
    }
}

