/*
 * Decompiled with CFR 0.152.
 */
package agents.spencerSchumann;

import agents.spencerSchumann.Enemy;
import agents.spencerSchumann.Scene;
import engine.core.MarioForwardModel;
import java.util.ArrayList;

public class EnemySimulator {
    public ArrayList<Enemy> enemies = new ArrayList();

    public EnemySimulator clone() {
        EnemySimulator enemySimulator = new EnemySimulator();
        for (Enemy enemy : this.enemies) {
            enemySimulator.enemies.add(enemy.clone());
        }
        return enemySimulator;
    }

    public void update(Scene scene) {
        for (Enemy enemy : this.enemies) {
            enemy.x += enemy.vx;
        }
    }

    public void update(MarioForwardModel marioForwardModel) {
        float[] fArray = marioForwardModel.getEnemiesFloatPos();
        ArrayList<Enemy> arrayList = new ArrayList<Enemy>();
        for (int i = 0; i < fArray.length; i += 3) {
            int n = (int)fArray[i];
            float f = fArray[i + 1];
            float f2 = fArray[i + 2];
            boolean bl = false;
            for (Enemy enemy : this.enemies) {
                if (n != enemy.type || f2 != enemy.y) continue;
                float f3 = Math.abs(enemy.x - f);
                if (f3 == 0.0f) {
                    arrayList.add(enemy);
                    this.enemies.remove(enemy);
                    bl = true;
                    break;
                }
                if (!(f3 < 5.0f)) continue;
                enemy.vx += f - enemy.x;
                enemy.x = f;
                arrayList.add(enemy);
                this.enemies.remove(enemy);
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(new Enemy(n, f, f2));
        }
        this.enemies = arrayList;
    }
}

