/*
 * Decompiled with CFR 0.152.
 */
package levelGenerators.linear;

import engine.core.MarioLevelGenerator;
import engine.core.MarioLevelModel;
import engine.core.MarioTimer;
import java.util.ArrayList;
import java.util.Random;

public class LevelGenerator
implements MarioLevelGenerator {
    private final int GROUND_PADDING = 5;
    private final int GROUND_LENGTH = 8;
    private final int GAP_LENGTH = 6;
    private final float GAP_PROB = 0.1f;
    private final float PIPE_PROB = 0.75f;
    private final int GROUND_PIPE_LENGTH = 10;
    private final int PIPE_HEIGHT = 6;
    private final float COLLECTIBLE_PROB = 0.75f;
    private final int GROUND_COLLECTIBLE_LENGTH = 6;
    private final int GROUND_ENEMY_LENGTH = 2;
    private Random rnd;

    private void placePipe(MarioLevelModel marioLevelModel, int n, int n2, int n3) {
        char c = 't';
        if (this.rnd.nextDouble() < 0.2) {
            c = 'T';
        }
        marioLevelModel.setRectangle(n, n2 - n3 + 1, 2, n3, c);
    }

    private void placeInterestingArrangement(MarioLevelModel marioLevelModel, int n, int n2, int n3) {
        char c;
        for (c = '\u0000'; c < n3 / 2; ++c) {
            char c2 = MarioLevelModel.getBumpableTiles()[this.rnd.nextInt(MarioLevelModel.getBumpableTiles().length)];
            marioLevelModel.setBlock(n + c, n2, c2);
            marioLevelModel.setBlock(n + n3 - 1 - c, n2, c2);
        }
        if (n3 % 2 == 1 && this.rnd.nextDouble() < 0.25) {
            c = MarioLevelModel.getBumpableTiles()[this.rnd.nextInt(MarioLevelModel.getBumpableTiles().length)];
            marioLevelModel.setBlock(n + n3 / 2, n2, c);
        }
        if (n2 > 4 && this.rnd.nextDouble() < 0.25) {
            this.placeInterestingArrangement(marioLevelModel, n + n3 / 4, n2 - 3 - this.rnd.nextInt(3), n3 / 2);
        }
    }

    private void placeEnemy(MarioLevelModel marioLevelModel, int n, int n2, int n3) {
        boolean bl = this.rnd.nextDouble() < 0.1;
        char c = MarioLevelModel.getEnemyCharacters(false)[this.rnd.nextInt(MarioLevelModel.getEnemyCharacters(false).length)];
        c = MarioLevelModel.getWingedEnemyVersion(c, bl);
        int n4 = n + this.rnd.nextInt(n2 - n);
        int n5 = 1 + this.rnd.nextInt(3);
        if (n5 > n2 - n - 1) {
            n5 = n2 - n - 1;
        }
        for (int i = 0; i < n5; ++i) {
            if (marioLevelModel.getBlock(n4 + i, n3) != '-') continue;
            marioLevelModel.setBlock(n4 + i, n3, c);
        }
    }

    @Override
    public String getGeneratedLevel(MarioLevelModel marioLevelModel, MarioTimer marioTimer) {
        int n;
        int n2;
        this.rnd = new Random();
        marioLevelModel.clearMap();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(0);
        int n3 = 4 + this.rnd.nextInt(4);
        int n4 = 0;
        for (int i = 0; i < marioLevelModel.getWidth(); ++i) {
            if (n3 > 0 || n4 == 0 || i < 5 || i > marioLevelModel.getWidth() - 1 - 5) {
                marioLevelModel.setBlock(i, marioLevelModel.getHeight() - 1, 'X');
                marioLevelModel.setBlock(i, marioLevelModel.getHeight() - 2, 'X');
                if (--n3 <= 0 && this.rnd.nextDouble() < (double)0.1f) {
                    n4 = 3 + this.rnd.nextInt(3);
                }
                if (arrayList.size() % 2 != 0) continue;
                arrayList.add(i);
                continue;
            }
            if (--n4 <= 0) {
                n3 = 4 + this.rnd.nextInt(4);
            }
            if (arrayList.size() % 2 != 1) continue;
            arrayList.add(i);
        }
        arrayList.add(marioLevelModel.getWidth() - 1);
        ArrayList arrayList2 = new ArrayList();
        for (n2 = 0; n2 < arrayList.size() / 2; ++n2) {
            n3 = (Integer)arrayList.get(2 * n2 + 1) - (Integer)arrayList.get(2 * n2);
            if (n3 <= 10 || !(this.rnd.nextDouble() < 0.75)) continue;
            n = (Integer)arrayList.get(2 * n2) + this.rnd.nextInt(n3 / 4) + 3;
            this.placePipe(marioLevelModel, n, marioLevelModel.getHeight() - 3, this.rnd.nextInt(4) + 2);
            arrayList2.add(arrayList.get(2 * n2));
            arrayList2.add(n - 1);
            arrayList2.add(n + 2);
            arrayList2.add(arrayList.get(2 * n2 + 1));
        }
        arrayList.clear();
        for (n2 = 0; n2 < arrayList2.size() / 2; ++n2) {
            n3 = (Integer)arrayList2.get(2 * n2 + 1) - (Integer)arrayList2.get(2 * n2);
            arrayList.add((Integer)arrayList2.get(2 * n2));
            arrayList.add(marioLevelModel.getHeight() - 3);
            arrayList.add((Integer)arrayList2.get(2 * n2 + 1));
            arrayList.add(marioLevelModel.getHeight() - 3);
            if (n3 <= 6 || !(this.rnd.nextDouble() < 0.75)) continue;
            n = (Integer)arrayList2.get(2 * n2) + this.rnd.nextInt(n3 / 3) + 1;
            int n5 = marioLevelModel.getHeight() - 5 - this.rnd.nextInt(3);
            int n6 = 1 + this.rnd.nextInt(n3 / 3);
            this.placeInterestingArrangement(marioLevelModel, n, n5, n6);
            arrayList.add(n + 1);
            arrayList.add(n5 - 1);
            arrayList.add(n + n6 - 1);
            arrayList.add(n5 - 1);
        }
        for (n2 = 1; n2 < arrayList.size() / 4; ++n2) {
            n3 = (Integer)arrayList.get(4 * n2 + 2) - (Integer)arrayList.get(4 * n2);
            if (n3 <= 2) continue;
            this.placeEnemy(marioLevelModel, (Integer)arrayList.get(4 * n2), (Integer)arrayList.get(4 * n2 + 2), (Integer)arrayList.get(4 * n2 + 1));
        }
        marioLevelModel.setBlock(1, marioLevelModel.getHeight() - 3, 'M');
        marioLevelModel.setBlock(marioLevelModel.getWidth() - 2, marioLevelModel.getHeight() - 3, '#');
        marioLevelModel.setBlock(marioLevelModel.getWidth() - 2, marioLevelModel.getHeight() - 4, 'F');
        return marioLevelModel.getMap();
    }

    @Override
    public String getGeneratorName() {
        return "LinearLevelGenerator";
    }
}

