/*
 * Decompiled with CFR 0.152.
 */
package agents.andySloane;

import agents.andySloane.MarioState;
import agents.andySloane.SpriteState;

final class MarioMath {
    private static final FallDistance _fallDistance = new FallDistance();

    MarioMath() {
    }

    public static float stepsToJump(float f) {
        if (f < 26.6f) {
            return 10.0f * f / 133.0f;
        }
        if ((double)f < 64.6) {
            return (float)(17.0 - Math.sqrt(281.0f - 80.0f * f / 19.0f)) / 2.0f;
        }
        return MarioMath.stepsToJump(64.0f) + MarioMath.stepsToJump(f - 64.0f);
    }

    private static float secantSolve(DistanceFunction distanceFunction, float f, float f2, float f3) {
        float f4;
        float f5 = f3;
        float f6 = f3 + 30.0f;
        do {
            float f7 = distanceFunction.value(f2, f5);
            float f8 = distanceFunction.value(f2, f6);
            f4 = (f8 - f) * (f6 - f5) / (f8 - f7);
            f5 = f6;
            f6 -= f4;
        } while ((double)Math.abs(f4) > 1.0E-4);
        return f6;
    }

    public static float runDistance(float f, float f2) {
        float f3 = (float)Math.pow(0.89f, f2);
        return (1320.0f * f2 - 20.0f * (f3 - 1.0f) * (55.0f * f - 534.0f)) / 121.0f;
    }

    public static float fallDistance(float f, float f2) {
        float f3 = (float)Math.pow(0.85f, f2);
        return 20.0f * f2 - 20.0f * (f3 - 1.0f) * (f - 20.0f) / 3.0f;
    }

    public static float runSpeed(float f, float f2) {
        float f3 = (float)Math.pow(0.89f, f2);
        return -9.70909f * (f3 - 1.0f) + f3 * f;
    }

    public static float stepsToRun(float f, float f2) {
        float f3;
        float f4 = 1.0f;
        float f5 = 2.0f;
        float f6 = 1.0f;
        int n = 0;
        if (f < 0.0f) {
            f6 = -1.0f;
            f = -f;
        }
        do {
            float f7 = MarioMath.runDistance(f2, f4);
            float f8 = MarioMath.runDistance(f2, f5);
            f3 = (f8 - f) * (f5 - f4) / (f8 - f7);
            f4 = f5;
            if (!((f5 -= f3) < 0.0f)) continue;
            f5 = -f5;
        } while (n++ < 1000 && (double)Math.abs(f3) > 1.0E-4);
        return f5 * f6;
    }

    public static float stepsToFall(float f, float f2) {
        if (f < 0.0f) {
            f = -f;
            f2 = -f2;
        }
        return MarioMath.secantSolve(_fallDistance, f, f2, 0.0f);
    }

    public static float stepsToStomp(MarioState marioState, SpriteState spriteState) {
        float f = MarioMath.stepsToRun(spriteState.x - marioState.x, marioState.xa);
        float f2 = 0.0f;
        if (spriteState.y < marioState.y) {
            if (marioState.onGround) {
                f2 = MarioMath.stepsToJump(marioState.y - spriteState.y);
            }
        } else if (spriteState.y > marioState.y) {
            f2 = MarioMath.stepsToFall(spriteState.y - marioState.y, marioState.ya);
        }
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public static boolean canReachLedge(float f, float f2, int n, float f3, float f4, float f5) {
        float f6 = 2.8045f;
        float f7 = MarioMath.stepsToRun(f4 - f, f2);
        float f8 = f3 - MarioMath.fallDistance(f6, f7 - (float)n);
        return f8 <= f5;
    }

    private static class FallDistance
    implements DistanceFunction {
        private FallDistance() {
        }

        @Override
        public float value(float f, float f2) {
            return MarioMath.fallDistance(f, f2);
        }
    }

    static interface DistanceFunction {
        public float value(float var1, float var2);
    }
}

